package com.esv.freight.app.module.customerservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.component.TokenComponent;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.feign.CustomerServiceInterface;
import com.esv.freight.app.module.customerservice.vo.CustomerServiceVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: app-service
 * @name: com.esv.freight.app.module.customerservice.controller.DriverCustomerServiceController
 * @author: 刘胜
 * @email: <liusheng@esvtek.com>
 * @createTime: 2020/8/12 13:32
 * @version: 1.0
 */
@RestController
@RequestMapping("/driverBackend/carrier")
@Slf4j
@Validated
public class DriverCustomerServiceController {

    private CustomerServiceInterface customerServiceInterface;
    private TokenComponent tokenComponent;

    @Autowired
    public DriverCustomerServiceController(CustomerServiceInterface customerServiceInterface, TokenComponent tokenComponent) {
        this.customerServiceInterface = customerServiceInterface;
        this.tokenComponent = tokenComponent;
    }

    /**
     * description 获取司机客服电话
     * param []
     * return com.esv.freight.app.common.response.EResponse
     * author 刘胜
     * createTime 2020/8/12 14:50
     **/
    @PostMapping("/customerservice")
    public EResponse driverCustomer(){
        JSONObject result =customerServiceInterface.driverCustomer();
        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }
        CustomerServiceVO customerServiceVO = new CustomerServiceVO();
        JSONObject data = result.getJSONObject("data");
        customerServiceVO.setPhone(data.getString("phone"));
        return EResponse.ok(customerServiceVO);
    }
}
