package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: app-service
 * @name: com.esv.freight.app.feign.CustomerServiceInterface
 * @author: 刘胜
 * @email: <liusheng@esvtek.com>
 * @createTime: 2020/8/12 14:13
 * @version: 1.0
 */
@FeignClient(value = "freight-customer-service")
public interface CustomerServiceInterface {
    /**
     * 获取货主客服电话
     * author 刘胜
     * createTime 2020/8/12 14:15
     **/
    @PostMapping(value = "/customer/goodsowner/customerservice")
    JSONObject ownerCustomer();
    /**
     * 获取司机客服电话
     * author 刘胜
     * createTime 2020/8/12 14:17
     **/
    @PostMapping(value = "/customer/carrier/customerservice")
    JSONObject driverCustomer();
}
