package com.esv.freight.app.config.mybatis;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.gateway.common.GatewayHeaders;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @description:
 * @project: esv-cc
 * @name: com.esv.cc.config.mybatis.MetaHandler
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/7 20:15
 * @version:1.0
 */
@Slf4j
@Component
public class EsvMetaObjectHandler implements MetaObjectHandler {

    private static final String CREATE_TIME_NAME = "createTime";
    private static final String UPDATE_TIME_NAME = "updateTime";
    private static final String TENANT_ID = "tenantId";
    private static final String DEPARTMENT_ID = "departmentId";

    @Override
    public void insertFill(MetaObject metaObject) {
        if (metaObject.hasSetter(CREATE_TIME_NAME)) {
            this.setFieldValByName(CREATE_TIME_NAME, new Date(), metaObject);
        }
        if (metaObject.hasSetter(UPDATE_TIME_NAME)) {
            this.setFieldValByName(UPDATE_TIME_NAME, new Date(), metaObject);
        }
        if (metaObject.hasSetter(TENANT_ID) && metaObject.getValue(TENANT_ID) == null) {
            String tenantId = ReqUtils.getRequestHeader(GatewayHeaders.TENANT_ID);
            this.setFieldValByName(TENANT_ID, Long.parseLong(tenantId), metaObject);
        }
        if (metaObject.hasSetter(DEPARTMENT_ID) && metaObject.getValue(DEPARTMENT_ID) == null) {
            String departmentId = ReqUtils.getRequestHeader(GatewayHeaders.DEPARTMENT_ID);
            this.setFieldValByName(DEPARTMENT_ID, Long.parseLong(departmentId), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        if (metaObject.hasSetter(UPDATE_TIME_NAME)) {
            this.setFieldValByName(UPDATE_TIME_NAME, new Date(), metaObject);
        }
    }
}
