package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.OwnerEvaluateInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/30 14:15
 * @version:1.0
 */
@FeignClient(value = "freight-tms-service")
public interface OwnerEvaluateInterface {

    /**
     * 分页查询
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/appraise/owner/list")
    JSONObject list(JSONObject bodyJson);

    /**
     * 评价详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/appraise/owner/detail")
    JSONObject detail(JSONObject bodyJson);

    /**
     * 新增评价
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/appraise/owner/add")
    JSONObject add(JSONObject bodyJson);
}
