package com.esv.freight.app.module.message.form;

import com.esv.freight.app.common.validator.groups.*;
import com.esv.freight.app.module.message.validator.groups.ValidatorDeleteByType;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description: 消息
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.message.form.MessageForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/10 16:40
 * @version:1.0
 */
@Data
public class MessageForm {

    /**
     * 消息ID
     **/
    @NotNull(message = "参数id不能为空", groups = {ValidatorDetail.class, ValidatorDelete.class, ValidatorDetail.class})
    private Long id;

    /**
     * 消息类型
     **/
    @NotNull(message = "参数messageType不能为空", groups = {ValidatorList.class, ValidatorDeleteByType.class})
    private Integer messageType;

    /**
     * 账号ID
     **/
    @NotNull(message = "参数accountId不能为空", groups = {ValidatorList.class, ValidatorUpdate.class, ValidatorDeleteByType.class})
    private Long accountId;

    /**
     * 页码
     **/
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 1000, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;
}
