package com.esv.freight.app.module.message.controller;

import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.module.message.form.PushMessageForm;
import com.esv.freight.app.module.message.service.BusinessMessageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 消息Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.message.controller.MessagePushController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/10 09:40
 * @version:1.0
 */
@RestController
@RequestMapping("/message")
@Slf4j
@Validated
public class MessagePushController {

    private BusinessMessageService businessMessageService;

    @Autowired
    public MessagePushController(BusinessMessageService businessMessageService) {
        this.businessMessageService = businessMessageService;
    }

    @PostMapping("/push2Account")
    public EResponse push2Account(@RequestHeader @RequestBody(required=false) @Validated(ValidatorInsert.class) PushMessageForm pushMessageForm) {

        businessMessageService.insertMessage(pushMessageForm);
        return EResponse.ok();
    }
}
