package com.esv.freight.app.module.account.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.component.TokenComponent;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.feign.CarrierInterface;
import com.esv.freight.app.feign.DriverInterface;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.form.LoginForm;
import com.esv.freight.app.module.account.form.ModifyPasswordForm;
import com.esv.freight.app.module.account.pojo.TokenInfoPojo;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.account.validator.groups.ValidatorResetPwd;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 密码Controller
 * @project: freight-app-service
 * @name: com.esv.freight.module.ownerBackend.account.controller.DriverPasswordController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/14 16:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/password")
@Slf4j
@Validated
public class DriverPasswordController {

    private NoticeInterface noticeInterface;
    private DriverInterface driverInterface;
    private TokenComponent tokenComponent;

    @Autowired
    public DriverPasswordController(DriverInterface driverInterface, NoticeInterface noticeInterface, TokenComponent tokenComponent) {
        this.noticeInterface = noticeInterface;
        this.driverInterface = driverInterface;
        this.tokenComponent = tokenComponent;
    }

    /**
     * description 重置密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 16:00
     **/
    @PostMapping("/reset")
    public EResponse reset(@RequestBody(required=false) @Validated(ValidatorResetPwd.class) LoginForm loginForm) {

        // 调用查询帐号详情接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("account", loginForm.getPhone());
        log.info(reqJson.toJSONString());
        JSONObject result = driverInterface.getDetailByAccount(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 1001) {
            return EResponse.error(1004, "无效的手机号");
        }

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        Long id = result.getJSONObject("data").getLong("id");

        // 调用通知服务验证短信接口
        reqJson.clear();
        reqJson.put("phone", loginForm.getPhone());
        reqJson.put("type", "reset_pwd");
        reqJson.put("captcha", loginForm.getSmsCode());
        log.info(reqJson.toJSONString());
        result = noticeInterface.checkSmsCaptcha(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        // 调用编辑帐号信息接口
        reqJson.clear();
        reqJson.put("id", id);
        reqJson.put("password", loginForm.getPwd());
        log.info(reqJson.toJSONString());
        result = driverInterface.resetDriverPwd(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 修改密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 16:00
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody(required=false) @Validated(ValidatorUpdate.class) ModifyPasswordForm modifyPasswordFrom) {

        TokenInfoPojo tokenInfoPojo = tokenComponent.getTokenInfo();
        String phone = tokenInfoPojo.getAccount();

        // 调用帐号密码校验接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("account", phone);
        reqJson.put("password", modifyPasswordFrom.getOldPwd());
        log.info(reqJson.toJSONString());
        JSONObject result = driverInterface.accountCheck(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 1002) {
            return EResponse.error(1001, "原密码错误");
        }

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        Long id = result.getJSONObject("data").getLong("id");

        // 调用编辑帐号信息接口
        reqJson.clear();
        reqJson.put("id", id);
        reqJson.put("password", modifyPasswordFrom.getNewPwd());
        log.info(reqJson.toJSONString());
        result = driverInterface.resetDriverPwd(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }
}
