package com.esv.freight.app.module.waybill.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.feign.TmsOrderInterface;
import com.esv.freight.app.feign.TmsWaybillInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.waybill.form.UploadEvidenceForm;
import com.esv.freight.app.module.waybill.form.WaybillMultiQueryForm;
import com.esv.freight.app.module.waybill.form.WaybillQueryForm;
import com.esv.freight.app.module.waybill.vo.WaybillListItemVO;
import com.esv.freight.app.module.waybill.vo.WaybillListVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description: 货主运单Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.waybill.controller.OwnerWaybillController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 15:00
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/waybill")
@Slf4j
@Validated
public class OwnerWaybillController {

    private TmsWaybillInterface tmsWaybillInterface;

    @Autowired
    public OwnerWaybillController(TmsWaybillInterface tmsWaybillInterface) {
        this.tmsWaybillInterface = tmsWaybillInterface;
    }

    /**
     * description 获取运单列表
     * param [accessToken, waybillQueryForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/22 15:00
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody(required=false) @Validated(ValidatorList.class) WaybillQueryForm waybillQueryForm) {

        // 调用运单列表分页查询接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("goodsOwnerId", waybillQueryForm.getUserId());
        reqJson.put("pageNum", waybillQueryForm.getPageNum());
        reqJson.put("pageSize", waybillQueryForm.getPageSize());
        reqJson.put("waybillStateList", waybillQueryForm.getWaybillStateList());
        if(!StringUtils.isEmpty(waybillQueryForm.getOrderNo())) {
            reqJson.put("orderNo", waybillQueryForm.getOrderNo());
        }
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.listWaybills(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        WaybillListVO pageResultVO = new WaybillListVO();
        JSONObject data = result.getJSONObject("data");
        pageResultVO.setPageSize(data.getLong("pageSize"));
        pageResultVO.setPageNum(data.getLong("pageNum"));
        pageResultVO.setTotal(data.getLong("totalSize"));
        pageResultVO.setRecordSize(data.getLong("recordSize"));
        if(pageResultVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<WaybillListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                WaybillListItemVO vo = new WaybillListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setVehicleId(object.getLong("vehicleId"));
                vo.setVehicleLicenseNo(object.getString("vehicleLicenseNo"));
                vo.setWaybillNo(object.getString("waybillNo"));
                vo.setWaybillState(object.getInteger("waybillState"));
                vo.setDeliveryStrategy(object.getInteger("deliveryStrategy"));
                vo.setOrderId(object.getLong("orderId"));
                vo.setOrderNo(object.getString("orderNo"));
                vo.setGoodsOwnerId(object.getLong("goodsOwnerId"));
                vo.setGoodsOwnerName(object.getString("goodsOwnerName"));
                vo.setDeliveryCityCode(object.getString("deliveryCityCode"));
                vo.setReceiveCityCode(object.getString("receiveCityCode"));
                vo.setDriverId(object.getLong("driverId"));
                vo.setDriverName(object.getString("driverName"));
                vo.setDriverPhone(object.getString("driverPhone"));
                vo.setSettlementType(object.getString("settlementType"));
                vo.setCarrierId(object.getLong("carrierId"));
                vo.setCarrierName(object.getString("carrierName"));
                vo.setBusinessType(object.getInteger("businessType"));
                vo.setGoodsType(object.getInteger("goodsType"));
                vo.setGoodsNameCode(object.getInteger("goodsNameCode"));
                vo.setGoodsName(object.getString("goodsName"));
                vo.setGoodsAmount(object.getBigDecimal("goodsAmount"));
                vo.setFreightUnitPriceOutput(object.getBigDecimal("freightUnitPriceOutput"));
                vo.setDeliveryEvidenceId(object.getLong("deliveryEvidenceId"));
                vo.setDeliveryTime(object.getDate("deliveryTime"));
                vo.setDeliveryGoodsAmount(object.getBigDecimal("deliveryGoodsAmount"));
                vo.setReceiveEvidenceId(object.getLong("receiveEvidenceId"));
                vo.setReceiveTime(object.getDate("receiveTime"));
                vo.setReceiveGoodsAmount(object.getBigDecimal("receiveGoodsAmount"));
                vo.setPayVerifyState(object.getInteger("payVerifyState"));
                vo.setGoodsUnit(object.getInteger("goodsUnit"));
                vo.setFreightUnitPriceInput(object.getBigDecimal("freightUnitPriceInput"));
                vo.setCreateTime(object.getDate("createTime"));
                vo.setRequiredDeliveryTime(object.getDate("requiredDeliveryTime"));
                vo.setRequiredReceiveTime(object.getDate("requiredReceiveTime"));
                records.add(vo);
            }

            pageResultVO.setRecord(records);
        }
        return EResponse.ok(pageResultVO);
    }

    /**
     * description 运单签收
     * param waybillQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/08 16:00
     **/
    @PostMapping("/sign")
    public EResponse sign(@RequestBody(required=false) @Validated(ValidatorDetail.class) WaybillQueryForm waybillQueryForm) {

        // 调用运单签收接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("id", waybillQueryForm.getWaybillId());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.sign(reqJson);
        log.info(result.toJSONString());

        if (result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 运单回单
     * param waybillQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/06/18 14:32
     **/
    @PostMapping("/receipt")
    public EResponse receipt(@RequestBody(required=false) @Validated(ValidatorDetail.class) WaybillQueryForm waybillQueryForm) {

        // 调用运单回单接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("id", waybillQueryForm.getWaybillId());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.receipt(reqJson);
        log.info(result.toJSONString());

        if (result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 运单搜索
     * param waybillQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/09 15:00
     **/
    @PostMapping("/list/multi/condition")
    public EResponse condition(@RequestBody(required=false) @Validated(ValidatorList.class) WaybillMultiQueryForm waybillMultiQueryForm) {

        // 调用运单列表分页查询接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("condition", waybillMultiQueryForm.getCondition());
        reqJson.put("pageNum", waybillMultiQueryForm.getPageNum());
        reqJson.put("pageSize", waybillMultiQueryForm.getPageSize());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.condition(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        WaybillListVO pageResultVO = new WaybillListVO();
        JSONObject data = result.getJSONObject("data");
        pageResultVO.setPageSize(data.getLong("pageSize"));
        pageResultVO.setPageNum(data.getLong("pageNum"));
        pageResultVO.setTotal(data.getLong("totalSize"));
        pageResultVO.setRecordSize(data.getLong("recordSize"));
        if(pageResultVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<WaybillListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                WaybillListItemVO vo = new WaybillListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setVehicleId(object.getLong("vehicleId"));
                vo.setVehicleLicenseNo(object.getString("vehicleLicenseNo"));
                vo.setWaybillNo(object.getString("waybillNo"));
                vo.setWaybillState(object.getInteger("waybillState"));
                vo.setDeliveryStrategy(object.getInteger("deliveryStrategy"));
                vo.setOrderId(object.getLong("orderId"));
                vo.setOrderNo(object.getString("orderNo"));
                vo.setGoodsOwnerId(object.getLong("goodsOwnerId"));
                vo.setGoodsOwnerName(object.getString("goodsOwnerName"));
                vo.setDeliveryCityCode(object.getString("deliveryCityCode"));
                vo.setReceiveCityCode(object.getString("receiveCityCode"));
                vo.setDriverId(object.getLong("driverId"));
                vo.setDriverName(object.getString("driverName"));
                vo.setDriverPhone(object.getString("driverPhone"));
                vo.setSettlementType(object.getString("settlementType"));
                vo.setCarrierId(object.getLong("carrierId"));
                vo.setCarrierName(object.getString("carrierName"));
                vo.setBusinessType(object.getInteger("businessType"));
                vo.setGoodsType(object.getInteger("goodsType"));
                vo.setGoodsNameCode(object.getInteger("goodsNameCode"));
                vo.setGoodsName(object.getString("goodsName"));
                vo.setGoodsAmount(object.getBigDecimal("goodsAmount"));
                vo.setFreightUnitPriceOutput(object.getBigDecimal("freightUnitPriceOutput"));
                vo.setDeliveryEvidenceId(object.getLong("deliveryEvidenceId"));
                vo.setDeliveryTime(object.getDate("deliveryTime"));
                vo.setDeliveryGoodsAmount(object.getBigDecimal("deliveryGoodsAmount"));
                vo.setReceiveEvidenceId(object.getLong("receiveEvidenceId"));
                vo.setReceiveTime(object.getDate("receiveTime"));
                vo.setReceiveGoodsAmount(object.getBigDecimal("receiveGoodsAmount"));
                vo.setPayVerifyState(object.getInteger("payVerifyState"));
                vo.setGoodsUnit(object.getInteger("goodsUnit"));
                vo.setFreightUnitPriceInput(object.getBigDecimal("freightUnitPriceInput"));
                vo.setCreateTime(object.getDate("createTime"));
                vo.setRequiredDeliveryTime(object.getDate("requiredDeliveryTime"));
                vo.setRequiredReceiveTime(object.getDate("requiredReceiveTime"));
                records.add(vo);
            }

            pageResultVO.setRecord(records);
        }
        return EResponse.ok(pageResultVO);
    }
}
