package com.esv.freight.app.config.mybatis;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @description:
 * @project: esv-cc
 * @name: com.esv.cc.config.mybatis.MetaHandler
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/7 20:15
 * @version:1.0
 */
@Slf4j
@Component
public class EsvMetaObjectHandler implements MetaObjectHandler {

    private static final String CREATE_TIME_NAME = "createTime";
    private static final String UPDATE_TIME_NAME = "updateTime";

    @Override
    public void insertFill(MetaObject metaObject) {
        if (metaObject.hasSetter(CREATE_TIME_NAME)) {
            this.setFieldValByName(CREATE_TIME_NAME, new Date(), metaObject);
        }
        if (metaObject.hasSetter(UPDATE_TIME_NAME)) {
            this.setFieldValByName(UPDATE_TIME_NAME, new Date(), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        if (metaObject.hasSetter(UPDATE_TIME_NAME)) {
            this.setFieldValByName(UPDATE_TIME_NAME, new Date(), metaObject);
        }
    }
}
