package com.esv.freight.app.module.order.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 订单详情VO
 * @project: Freight
 * @name: com.esv.freight.app.module.order.vo.OrderDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 10:00
 * @version:1.0
 */
@Data
public class OrderDetailVO {

    /**
     * 订单id
     */
    private Long id;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 订单状态.
     */
    private Integer orderState;

    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 业务类型
     */
    private Integer businessType;

    /**
     * 货物类型
     */
    private Integer goodsType;

    /**
     * 货物名称编码
     */
    private Integer goodsNameCode;

    /**
     * 货物名称
     */
    private String goodsName;

    /**
     * 货物明细
     */
    private String goodsDetail;

    /**
     * 货物订单量
     */
    private BigDecimal goodsTotalAmount;

    /**
     * 货物剩余订单量
     */
    private BigDecimal remainingGoodsAmount;

    /**
     * 货物单位
     */
    private Integer goodsUnit;

    /**
     * 货物单价
     */
    private BigDecimal goodsUnitPrice;

    /**
     * 运费单价（收入）
     */
    private BigDecimal freightUnitPriceInput;

    /**
     * 发货地址ID
     */
    private Long deliveryAddressId;

    /**
     * 发货地址名称
     */
    private String deliveryAddressName;

    /**
     * 发货地址省份
     */
    private String deliveryProvinceCode;

    /**
     * 发货地址城市
     */
    private String deliveryCityCode;

    /**
     * 发货地址区、县
     */
    private String deliveryDistrictCode;

    /**
     * 发货详细地址
     */
    private String deliveryDetailAddress;

    /**
     * 发货人
     */
    private String deliverer;

    /**
     * 发货人手机号
     */
    private String delivererPhone;

    /**
     * 收货地址ID
     */
    private Long receiveAddressId;

    /**
     * 收货地址名称
     */
    private String receiveAddressName;

    /**
     * 收货地址省份
     */
    private String receiveProvinceCode;

    /**
     * 收货地址城市
     */
    private String receiveCityCode;

    /**
     * 收货地址区、县
     */
    private String receiveDistrictCode;

    /**
     * 收货详细地址
     */
    private String receiveDetailAddress;

    /**
     * 收货人
     */
    private String receiver;

    /**
     * 收货人电话
     */
    private String receiverPhone;

    /**
     * 要求发货时间
     */
    private Long requiredDeliveryTime;

    /**
     * 要求交货时间
     */
    private Long requiredReceiveTime;

    /**
     * 车辆类型，主类型
     */
    private Integer vehicleTypeMain;

    /**
     * 车辆类型，子类型
     */
    private Integer vehicleTypeSub;

    /**
     * 车长
     */
    private BigDecimal vehicleLength;

    /**
     * 备注
     */
    private String remark;

    /**
     * 客户下单时间
     */
    private Long placeOrderTime;

    /**
     * 要求回单时间
     */
    private Long requiredReceiptTime;

    /**
     * 是否允许议价
     */
    private Integer bargainAllowed;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
