package com.esv.freight.app.module.contract.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.FeignUtils;
import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.feign.OwnerComplaintInterface;
import com.esv.freight.app.feign.OwnerContractInterface;
import com.esv.freight.app.module.complaint.form.OwnerComplaintForm;
import com.esv.freight.app.module.contract.form.ContractQueryForm;
import com.esv.freight.app.module.contract.pojo.OwnerContractPojo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 货主合同Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.contract.controller.OwnerContractController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/05 13:30
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/contract")
@Slf4j
@Validated
public class OwnerContractController {

    private OwnerContractInterface ownerContractInterface;

    @Autowired
    public OwnerContractController(OwnerContractInterface ownerContractInterface) {
        this.ownerContractInterface = ownerContractInterface;
    }

    /**
     * description 获取线下文本合同（货主）详情
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/06/05 13:30
     **/
    @PostMapping("/detail")
    public EResponse detail(@RequestBody @Validated(ValidatorDetail.class) ContractQueryForm form) throws EException {
        // 调用投诉列表分页查询接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("contractNumber", form.getContractNumber());
        log.info(reqJson.toJSONString());
        JSONObject result = ownerContractInterface.detail(reqJson);
        log.info(result.toJSONString());

        if(!FeignUtils.isFeignSuccess(result)) {
            return FeignUtils.getFeignEResponse(result);
        }

        OwnerContractPojo driverAccountInfoPojo = JSONObject.toJavaObject(FeignUtils.getFeignDataJson(result), OwnerContractPojo.class);
        return EResponse.ok(driverAccountInfoPojo);
}
}
