package com.esv.freight.app.module.waybill.form;

import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.waybill.form.UploadEvidenceForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/08 16:00
 * @version:1.0
 */
@Data
public class UploadEvidenceForm {

    /**
     * 运单ID
     */
    @NotNull(message = "参数运单ID不能为空", groups = {ValidatorInsert.class})
    private Long waybillId;

    /**
     * 发货量
     */
    @NotNull(message = "参数发货量不能为空", groups = {ValidatorInsert.class})
    private BigDecimal goodsAmount;

    /**
     * 发货/交货时间
     */
    @NotNull(message = "参数发货时间不能为空", groups = {ValidatorInsert.class})
    private Long occurrenceTime;

    /**
     * 发货单据01URL
     */
    @Length(max = 500, message = "参数pictureUrl01长度不合法", groups = {ValidatorInsert.class})
    private String pictureUrl01;

    /**
     * 发货单据02URL
     */
    @Length(max = 500, message = "参数pictureUrl01长度不合法", groups = {ValidatorInsert.class})
    private String pictureUrl02;

    /**
     * 发货单据03URL
     */
    @Length(max = 500, message = "参数pictureUrl01长度不合法", groups = {ValidatorInsert.class})
    private String pictureUrl03;

    /**
     * 发货单据04URL
     */
    @Length(max = 500, message = "参数pictureUrl01长度不合法", groups = {ValidatorInsert.class})
    private String pictureUrl04;
}
