package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.DictInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 13:48
 * @version:1.0
 */
@FeignClient(value = "freight-base-service")
public interface DictInterface {

    /**
     * 获取基础字典表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/base/dict/get")
    JSONObject getDictByTypes(JSONObject bodyJson);
}

