package com.esv.freight.app.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;

/**
 * @description:
 * @project: app-service
 * @name: com.esv.freight.app.common.util.FeignUtils
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/14 10:04
 * @version:1.0
 */
public class FeignUtils {

    /**
     * description 判断Feign请求是否成功
     * param [feignResult]
     * return java.lang.Boolean
     * author Administrator
     * createTime 2020/05/14 10:06
     **/
    public static Boolean isFeignSuccess(JSONObject feignResult) {
        if (ECode.SUCCESS.code() == feignResult.getIntValue("code")) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * description 包装Feign请求的错误返回
     * param [feignResult]
     * return com.esv.freight.app.common.response.EResponse
     * author Administrator
     * createTime 2020/05/14 10:10
     **/
    public static EResponse getFeignEResponse(JSONObject feignResult) {
        return EResponse.error(feignResult.getInteger("code"), feignResult.getString("message"));
    }

    /**
     * description 获取Feign请求返回数据JSONObject格式
     * param [feignResult]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/14 11:11
     **/
    public static JSONObject getFeignDataJson(JSONObject feignResult) {
        return feignResult.getJSONObject("data");
    }

    /**
     * description 获取Feign请求返回数据JSONArray格式
     * param [feignResult]
     * return com.alibaba.fastjson.JSONArray
     * author Administrator
     * createTime 2020/05/14 11:12
     **/
    public static JSONArray getFeignDataJsonArray(JSONObject feignResult) {
        return feignResult.getJSONArray("data");
    }

}
