package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.DriverBillInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/28 14:20
 * @version:1.0
 */
@FeignClient(value = "freight-bill-service")
public interface DriverBillInterface {

    /**
     * 分页查询
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "bill/verify/paybill/list/app")
    JSONObject listBillDriver(JSONObject bodyJson);

    /**
     * 账单详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "bill/verify/paybill/detail/app")
    JSONObject billDriverDetail(JSONObject bodyJson);

    /**
     * 确认对账
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "bill/verify/paybill/confirmBill")
    JSONObject confirmBill(JSONObject bodyJson);

    /**
     * 运单费用明细
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "bill/payData/detail")
    JSONObject detail(JSONObject bodyJson);
}
