package com.esv.freight.app.module.grabbing.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 订单列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.grabbing.vo.GrabListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/24 16:00
 * @version:1.0
 */
@Data
public class GrabListItemVO {

    /**
     * 抢单ID
     */
    private Long id;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 发货地址 省份
     */
    private String deliveryProvinceCode;

    /**
     * 发货地址 城市
     */
    private String deliveryCityCode;

    /**
     * 交货地址 省份
     */
    private String receiveProvinceCode;

    /**
     * 交货地址 城市
     */
    private String receiveCityCode;

    /**
     * 货物类型
     */
    private Integer goodsType;

    /**
     * 货物名称编码
     */
    private Integer goodsName;

    /**
     * 货物订单量
     */
    private BigDecimal goodsTotalAmount;

    /**
     * 货物单位
     */
    private String goodsUnit;

    /**
     * 要求发货时间
     */
    private Date requiredDeliveryTime;

    /**
     * 订单创建时间
     */
    private Date createTime;

    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 运费单价（支出）
     */
    private BigDecimal freightUnitPriceOutput;

    /**
     * 需求车辆数
     */
    private Integer requiredVehicleCount;

    /**
     * 当前抢单车辆数
     */
    private Integer currentVehicleCount;
}
