package com.esv.freight.app.module.account.controller;

import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.form.LoginForm;
import com.esv.freight.app.module.account.form.ModifyPasswordForm;
import com.esv.freight.app.module.account.service.AppLoginService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 密码Controller
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.controller.DriverPasswordController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/14 16:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/password")
@Slf4j
@Validated
public class DriverPasswordController {

    private NoticeInterface noticeInterface;
    private AppLoginService appLoginService;

    @Autowired
    public DriverPasswordController(NoticeInterface noticeInterface, AppLoginService appLoginService) {
        this.noticeInterface = noticeInterface;
        this.appLoginService = appLoginService;
    }

    /**
     * description 重置密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 16:00
     **/
    @PostMapping("/reset")
    public EResponse reset(@RequestBody(required=false) @Validated(ValidatorInsert.class) LoginForm loginForm) {

        return EResponse.error(1001, "短信验证码错误或已失效");
    }

    /**
     * description 修改密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 16:00
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorInsert.class) ModifyPasswordForm modifyPasswordFrom) {

        return EResponse.ok();
    }
}
