package com.esv.freight.app.module.vehicle.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;

/**
 * @description: 车辆列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.vehicle.vo.VehicleListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/28 16:00
 * @version:1.0
 */
@Data
public class VehicleListItemVO {
    /**
     *
     */
    private Long id;

    /**
     * 车牌号
     */
    private String licenseNumber;

    /**
     * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    private Integer auditStatus;
    /**
     * 车辆类型(字典表)
     */
    private Integer vehicleType;
    /**
     * 二级车辆类型(字典表)
     */
    private Integer vehicleType2;
    /**
     * 核定载质量(吨)
     */
    private BigDecimal loadCapacity;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
