package com.esv.freight.app.module.vehicle.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.feign.VehicleInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.order.form.OrderForm;
import com.esv.freight.app.module.order.vo.OrderListItemVO;
import com.esv.freight.app.module.order.vo.OrderListVO;
import com.esv.freight.app.module.vehicle.form.VehicleForm;
import com.esv.freight.app.module.vehicle.form.VehicleQueryForm;
import com.esv.freight.app.module.vehicle.vo.VehicleDetailVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 车辆Controller
 * @project: Freight
 * @name: com.esv.freight.app.module.vehicle.controller.VehicleController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/28 17:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/vehicle")
@Slf4j
@Validated
public class VehicleController {

    private AppLoginService appLoginService;
    private VehicleInterface vehicleInterface;

    @Autowired
    public VehicleController(VehicleInterface vehicleInterface, AppLoginService appLoginService) {
        this.appLoginService = appLoginService;
        this.vehicleInterface = vehicleInterface;
    }

    /**
     * description 添加车辆
     * param vehicleForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/28 17:00
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody(required=false) @Validated(ValidatorInsert.class) VehicleForm vehicleForm) {

        String accessToken = ReqUtils.getTokenInfo().getAccessToken();
        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        // 调用新增车辆接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("carrierId", vehicleForm.getCarrierId());
        reqJson.put("licenseNumber", vehicleForm.getLicenseNumber());
        reqJson.put("licenseType", vehicleForm.getLicenseType());
        reqJson.put("licenseColor", vehicleForm.getLicenseColor());
        reqJson.put("vehicleType", vehicleForm.getVehicleType());
        reqJson.put("vehicleType2", vehicleForm.getVehicleType2());
        reqJson.put("vehicleLength", vehicleForm.getVehicleLength());
        reqJson.put("vehicleWidth", vehicleForm.getVehicleWidth());
        reqJson.put("vehicleHeight", vehicleForm.getVehicleHeight());
        reqJson.put("vehicleBelong", "1"); // 车辆所属(字典表)：1-自有车、2-外协车
        reqJson.put("yearAuditDate", vehicleForm.getYearAuditDate());
        reqJson.put("energyType", vehicleForm.getEnergyType());
        reqJson.put("vehicleLicenseNumber", vehicleForm.getVehicleLicenseNumber());
        reqJson.put("loadCapacity", vehicleForm.getLoadCapacity());
        reqJson.put("totalMass", vehicleForm.getTotalMass());
        reqJson.put("unladenMass", vehicleForm.getUnladenMass());
        reqJson.put("vehicleOwner", vehicleForm.getVehicleOwner());
        reqJson.put("vehicleOwnerCode", vehicleForm.getVehicleOwnerCode());
        reqJson.put("useNature", vehicleForm.getUseNature());
        reqJson.put("registerDate", vehicleForm.getRegisterDate());
        reqJson.put("vin", vehicleForm.getVin());
        reqJson.put("brandModel", vehicleForm.getBrandModel());
        reqJson.put("engineNumber", vehicleForm.getEngineNumber());
        reqJson.put("vehicleLicenseIssuedDate", vehicleForm.getVehicleLicenseIssuedDate());
        reqJson.put("vehicleLicenseExpireDate", vehicleForm.getVehicleLicenseExpireDate());
        reqJson.put("vehicleLicenseIssueDepartment", vehicleForm.getVehicleLicenseIssueDepartment());
        reqJson.put("roadCertificateNumber", vehicleForm.getRoadCertificateNumber());
        reqJson.put("businessLicenseNumber", vehicleForm.getBusinessLicenseNumber());
        reqJson.put("businessLicenseExpireDate", vehicleForm.getBusinessLicenseExpireDate());
        reqJson.put("vehicleProvinceCode", vehicleForm.getVehicleProvinceCode());
        reqJson.put("vehicleCityCode", vehicleForm.getVehicleCityCode());
        reqJson.put("vehicleDistrictCode", vehicleForm.getVehicleDistrictCode());
        reqJson.put("etc", vehicleForm.getEtc());
        reqJson.put("vehicleHeadUrl", vehicleForm.getVehicleHeadUrl());
        reqJson.put("vehicleHeadPersonUrl", vehicleForm.getVehicleHeadPersonUrl());
        reqJson.put("vehicleLicenseFrontUrl", vehicleForm.getVehicleLicenseFrontUrl());
        reqJson.put("vehicleLicenseBackUrl", vehicleForm.getVehicleLicenseBackUrl());
        reqJson.put("roadCertificateFrontUrl", vehicleForm.getRoadCertificateFrontUrl());
        reqJson.put("attachedStatementUrl", vehicleForm.getAttachedStatementUrl());
        log.info(reqJson.toJSONString());
        JSONObject result = vehicleInterface.add(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 编辑车辆
     * param vehicleForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/28 17:00
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody(required=false) @Validated(ValidatorUpdate.class) VehicleForm vehicleForm) {
        String accessToken = ReqUtils.getTokenInfo().getAccessToken();
        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        // 调用编辑车辆接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("id", vehicleForm.getId());
        reqJson.put("licenseNumber", vehicleForm.getLicenseNumber());
        reqJson.put("licenseType", vehicleForm.getLicenseType());
        reqJson.put("licenseColor", vehicleForm.getLicenseColor());
        reqJson.put("vehicleType", vehicleForm.getVehicleType());
        reqJson.put("vehicleType2", vehicleForm.getVehicleType2());
        reqJson.put("vehicleLength", vehicleForm.getVehicleLength());
        reqJson.put("vehicleWidth", vehicleForm.getVehicleWidth());
        reqJson.put("vehicleHeight", vehicleForm.getVehicleHeight());
        reqJson.put("vehicleBelong", "1"); // 车辆所属(字典表)：1-自有车、2-外协车
        reqJson.put("yearAuditDate", vehicleForm.getYearAuditDate());
        reqJson.put("energyType", vehicleForm.getEnergyType());
        reqJson.put("vehicleLicenseNumber", vehicleForm.getVehicleLicenseNumber());
        reqJson.put("loadCapacity", vehicleForm.getLoadCapacity());
        reqJson.put("totalMass", vehicleForm.getTotalMass());
        reqJson.put("unladenMass", vehicleForm.getUnladenMass());
        reqJson.put("vehicleOwner", vehicleForm.getVehicleOwner());
        reqJson.put("vehicleOwnerCode", vehicleForm.getVehicleOwnerCode());
        reqJson.put("useNature", vehicleForm.getUseNature());
        reqJson.put("registerDate", vehicleForm.getRegisterDate());
        reqJson.put("vin", vehicleForm.getVin());
        reqJson.put("brandModel", vehicleForm.getBrandModel());
        reqJson.put("engineNumber", vehicleForm.getEngineNumber());
        reqJson.put("vehicleLicenseIssuedDate", vehicleForm.getVehicleLicenseIssuedDate());
        reqJson.put("vehicleLicenseExpireDate", vehicleForm.getVehicleLicenseExpireDate());
        reqJson.put("vehicleLicenseIssueDepartment", vehicleForm.getVehicleLicenseIssueDepartment());
        reqJson.put("roadCertificateNumber", vehicleForm.getRoadCertificateNumber());
        reqJson.put("businessLicenseNumber", vehicleForm.getBusinessLicenseNumber());
        reqJson.put("businessLicenseExpireDate", vehicleForm.getBusinessLicenseExpireDate());
        reqJson.put("vehicleProvinceCode", vehicleForm.getVehicleProvinceCode());
        reqJson.put("vehicleCityCode", vehicleForm.getVehicleCityCode());
        reqJson.put("vehicleDistrictCode", vehicleForm.getVehicleDistrictCode());
        reqJson.put("etc", vehicleForm.getEtc());
        reqJson.put("vehicleHeadUrl", vehicleForm.getVehicleHeadUrl());
        reqJson.put("vehicleHeadPersonUrl", vehicleForm.getVehicleHeadPersonUrl());
        reqJson.put("vehicleLicenseFrontUrl", vehicleForm.getVehicleLicenseFrontUrl());
        reqJson.put("vehicleLicenseBackUrl", vehicleForm.getVehicleLicenseBackUrl());
        reqJson.put("roadCertificateFrontUrl", vehicleForm.getRoadCertificateFrontUrl());
        reqJson.put("attachedStatementUrl", vehicleForm.getAttachedStatementUrl());
        log.info(reqJson.toJSONString());
        JSONObject result = vehicleInterface.edit(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 获取车辆详情
     * param vehicleQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/28 17:00
     **/
    @PostMapping("/detail")
    public EResponse detail(@RequestBody(required=false) @Validated(ValidatorUpdate.class) VehicleQueryForm vehicleQueryForm) {
        String accessToken = ReqUtils.getTokenInfo().getAccessToken();
        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        // 调用获取订单详情接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("id", vehicleQueryForm.getId());
        log.info(reqJson.toJSONString());
        JSONObject result = vehicleInterface.detail(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        VehicleDetailVO vehicleDetailVO = new VehicleDetailVO();
        JSONObject data = result.getJSONObject("data");
        vehicleDetailVO.setId(data.getLong("id"));
        vehicleDetailVO.setCarrierId(data.getLong("carrierId"));
        vehicleDetailVO.setCarrierName(data.getString("carrierName"));
        vehicleDetailVO.setLicenseNumber(data.getString("licenseNumber"));
        vehicleDetailVO.setVehicleStatus(data.getString("vehicleStatus"));
        vehicleDetailVO.setAuditStatus(data.getInteger("auditStatus"));
        vehicleDetailVO.setLicenseType(data.getInteger("licenseType"));
        vehicleDetailVO.setLicenseColor(data.getInteger("licenseColor"));
        vehicleDetailVO.setVehicleType(data.getInteger("vehicleType"));
        vehicleDetailVO.setVehicleType2(data.getInteger("vehicleType2"));
        vehicleDetailVO.setVehicleLength(data.getInteger("vehicleLength"));
        vehicleDetailVO.setVehicleWidth(data.getInteger("vehicleWidth"));
        vehicleDetailVO.setVehicleHeight(data.getInteger("vehicleHeight"));
        vehicleDetailVO.setVehicleBelong(data.getInteger("vehicleBelong"));
        vehicleDetailVO.setYearAuditDate(data.getString("yearAuditDate"));
        vehicleDetailVO.setEnergyType(data.getInteger("energyType"));
        vehicleDetailVO.setVehicleLicenseNumber(data.getString("vehicleLicenseNumber"));
        vehicleDetailVO.setLoadCapacity(data.getBigDecimal("loadCapacity"));
        vehicleDetailVO.setTotalMass(data.getBigDecimal("totalMass"));
        vehicleDetailVO.setUnladenMass(data.getBigDecimal("unladenMass"));
        vehicleDetailVO.setVehicleOwner(data.getString("vehicleOwner"));
        vehicleDetailVO.setVehicleOwnerCode(data.getString("vehicleOwnerCode"));
        vehicleDetailVO.setUseNature(data.getString("useNature"));
        vehicleDetailVO.setRegisterDate(data.getString("registerDate"));
        vehicleDetailVO.setVin(data.getString("vin"));
        vehicleDetailVO.setBrandModel(data.getString("brandModel"));
        vehicleDetailVO.setEngineNumber(data.getString("engineNumber"));
        vehicleDetailVO.setVehicleLicenseIssuedDate(data.getString("vehicleLicenseIssuedDate"));
        vehicleDetailVO.setVehicleLicenseExpireDate(data.getString("vehicleLicenseExpireDate"));
        vehicleDetailVO.setVehicleLicenseIssueDepartment(data.getString("vehicleLicenseIssueDepartment"));
        vehicleDetailVO.setRoadCertificateNumber(data.getString("roadCertificateNumber"));
        vehicleDetailVO.setBusinessLicenseNumber(data.getString("businessLicenseNumber"));
        vehicleDetailVO.setBusinessLicenseExpireDate(data.getString("businessLicenseExpireDate"));
        vehicleDetailVO.setVehicleProvinceCode(data.getString("vehicleProvinceCode"));
        vehicleDetailVO.setVehicleCityCode(data.getString("vehicleCityCode"));
        vehicleDetailVO.setVehicleDistrictCode(data.getString("vehicleDistrictCode"));
        vehicleDetailVO.setEtc(data.getString("etc"));
        vehicleDetailVO.setUploadState(data.getInteger("uploadState"));
        vehicleDetailVO.setUploadTime(data.getString("uploadTime"));
        vehicleDetailVO.setVehicleHeadUrl(data.getString("vehicleHeadUrl"));
        vehicleDetailVO.setVehicleHeadPersonUrl(data.getString("vehicleHeadPersonUrl"));
        vehicleDetailVO.setVehicleLicenseFrontUrl(data.getString("vehicleLicenseFrontUrl"));
        vehicleDetailVO.setVehicleLicenseBackUrl(data.getString("vehicleLicenseBackUrl"));
        vehicleDetailVO.setRoadCertificateFrontUrl(data.getString("roadCertificateFrontUrl"));
        vehicleDetailVO.setAttachedStatementUrl(data.getString("attachedStatementUrl"));
        return EResponse.ok(vehicleDetailVO);
    }

    /**
     * description 分页查询车辆列表
     * param vehicleQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/28 17:00
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody(required=false) @Validated(ValidatorUpdate.class) VehicleQueryForm vehicleQueryForm) {
        String accessToken = ReqUtils.getTokenInfo().getAccessToken();
        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        // 调用订单列表分页查询接口
   /*     JSONObject reqJson = new JSONObject();
        reqJson.put("goodsOwnerId", orderQueryForm.getGoodsOwnerId());
        reqJson.put("pageNum", orderQueryForm.getPageNum());
        reqJson.put("pageSize", orderQueryForm.getPageSize());
        reqJson.put("orderStateList", orderQueryForm.getOrderStateList());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsInterface.listOrders(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        OrderListVO pageResultVO = new OrderListVO();
        JSONObject data = result.getJSONObject("data");
        pageResultVO.setPageSize(data.getLong("pageSize"));
        pageResultVO.setPageNum(data.getLong("pageNum"));
        pageResultVO.setTotal(data.getLong("total"));
        pageResultVO.setRecordSize(data.getLong("recordSize"));
        if(pageResultVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<OrderListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                OrderListItemVO vo = new OrderListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setOrderNO(object.getString("orderNo"));
                vo.setOrderState(object.getInteger("orderState"));
                vo.setAuditState(object.getInteger("auditState"));
                vo.setDeliveryCityCode(object.getString("deliveryCityCode"));
                vo.setReceiveCityCode(object.getString("receiveCityCode"));
                vo.setBusinessType(object.getInteger("businessType"));
                vo.setGoodsType(object.getInteger("goodsType"));
                vo.setGoodsName(object.getInteger("goodsName"));
                vo.setGoodsDetail(object.getString("goodsDetail"));
                vo.setGoodsTotalAmount(object.getBigDecimal("goodsTotalAmount"));
                vo.setGoodsUnit(object.getString("goodsUnit"));
                vo.setRequiredDeliveryTime(object.getDate("requiredDeliveryTime"));
                vo.setRequiredReceiveTime(object.getDate("requiredReceiveTime"));
                vo.setCreateTime(object.getDate("createTime"));
                vo.setOrderSource(object.getString("orderSource"));
                records.add(vo);
            }

            pageResultVO.setRecord(records);
        }*/
        return EResponse.ok();
    }
}
