package com.esv.freight.app.module.waybill.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 运单列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.waybill.vo.WaybillListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class WaybillListItemVO {

    /**
     * 	运单ID
     */
    private Long id;

    /**
     * 	运单号，YD+”8位日期“+”6位序号“
     */
    private String waybillNO;

    /**
     * 	订单号
     */
    private String orderNO;

    /**
     * 运单状态 1-装货中；2-运输中；3-已交货；4-已签收；5-已回单；6-已作废
     */
    private Integer waybillState;

    /**
     * 发货城市编码
     */
    private String deliveryCity;

    /**
     * 收货城市编码
     */
    private String receiveCity;

    /**
     * 货物名称编码
     */
    private Integer goodsName;

    /**
     * 货物订单量
     */
    private BigDecimal goodsTotalAmount;

    /**
     * 货物单位
     */
    private String goodsUnit;

    /**
     * 运单生成时间
     */
    private Date createTime;

    /**
     * 执行车辆ID
     */
    private String vehicleId;

    /**
     * 执行车辆车牌号
     */
    private String vehicleNum;
}
