package com.esv.freight.app.module.address.form;

import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.address.form.AddressQueryForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 15:00
 * @version:1.0
 */
@Data
public class AddressQueryForm {

    /**
     * 地址ID
     **/
    @NotBlank(message = "参数id不能为空", groups = {ValidatorDelete.class})
    private String id;

    /**
     * 货主ID
     **/
    @NotNull(message = "参数ownerId不能为空", groups = {ValidatorList.class})
    private Long ownerId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
