package com.esv.freight.app.module.account.form;

import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @description: 账号实名认证验证类
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.form.RealNameAuthForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 10:00
 * @version:1.0
 */
@Data
public class RealNameAuthForm {

    /**
     * 货主ID
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class})
    private Long id;

    /**
     * 货主类型：1-个人、2-企业
     */
    @Pattern(regexp = "[12]", message = "参数ownerType不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数ownerType不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String ownerType;

    /**
     * 身份证正面图片数据
     */
    @NotBlank(message = "参数idCardFileFront不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String idCardFileFront;

    /**
     * 身份证背面图片数据
     */
    @NotBlank(message = "参数idCardFileBack不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String idCardFileBack;

    /**
     * 姓名
     */
    @Length(max = 20, message = "参数name长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数name不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String name;

    /**
     * 身份证号码
     */
    @Length(min = 18, max = 18, message = "参数idCard长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCard不能为空", groups = {ValidatorInsert.class})
    private String idCard;

    /**
     * 	身份证有效期，格式yyyy.MM.dd，或长期
     */
    @Length(max = 50, message = "参数idCardExpireDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String idCardExpireDate;

    /**
     * 	省份代码
     */
    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数provinceCode不能为空", groups = {ValidatorInsert.class})
    private String provinceCode;

    /**
     * 	市代码
     */
    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数cityCode不能为空", groups = {ValidatorInsert.class})
    private String cityCode;

    /**
     *  区县代码
     */
    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数districtCode不能为空", groups = {ValidatorInsert.class})
    private String districtCode;

    /**
     * 	详细地址
     */
    @Length(max = 100, message = "参数detailAddress长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数detailAddress不能为空", groups = {ValidatorInsert.class})
    private String detailAddress;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
