package com.esv.freight.app.common.filter;

import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.AESSecretUtils;
import com.esv.freight.app.common.wrapper.RestRequestWrapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 * @description: 权限过滤器
 * @project: app-service
 * @name: com.esv.freight.app.common.filter.AuthFilter
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 15:02
 * @version:1.0
 */
@Slf4j
@RefreshScope
public class AuthFilter implements Filter {

    @Value("${aes.sha1prng.key:freight-app-service-001}")
    private String AES_KEY;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        /************************ Token加解密示例 ************************/
        log.info(AES_KEY);
        String tokenTest = "1,13912345678,sn001," + System.currentTimeMillis();
        String accessTokenTest = AESSecretUtils.encryptToStr(tokenTest, AES_KEY);
        log.info(tokenTest);
        log.info(accessTokenTest);
        log.info(AESSecretUtils.decryptToStr(accessTokenTest, AES_KEY));
        /************************ Token加解密示例 ************************/



        RestRequestWrapper requestWrapper = new RestRequestWrapper((HttpServletRequest)servletRequest);
        String url = requestWrapper.getRequestURI();

        if("/app/ownerBackend/account/login/loginByPwd".equals(url) ||
                "/app/ownerBackend/account/login/loginBySms".equals(url)){

            //此类接口不校验token
        }
        else {
            HttpServletRequest request = (HttpServletRequest) servletRequest;
            HttpServletResponse response = (HttpServletResponse) servletResponse;
            String accessToken = request.getHeader("Union-Authorization");
            if (StringUtils.isBlank(accessToken)) {
                this.errorResponse(EResponse.error(ECode.TOKEN_INVALID), response);
                return;
            } else {
                // 解析并校验Token
                String analysisToken = AESSecretUtils.decryptToStr(accessToken, AES_KEY);
            }
        }

        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {

    }

    private void errorResponse(EResponse eResponse, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter(response.getOutputStream(), "UTF-8");
            writer = new PrintWriter(osw, true);
            writer.write(eResponse.toString());
            writer.flush();
            osw.close();
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        } finally {
            if (null != writer) {
                writer.close();
            }
            if (null != osw) {
                try {
                    osw.close();
                } catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }
}
