package com.esv.freight.app.module.message.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.app.common.vo.PageResultVO;
import com.esv.freight.app.module.message.entity.BusinessMessageEntity;
import com.esv.freight.app.module.message.form.MessageForm;
import com.esv.freight.app.module.message.form.PushMessageForm;
import com.esv.freight.app.module.message.vo.MessageDetailVO;
import com.esv.freight.app.module.message.vo.MessageTypeVO;

import java.util.List;

/**
 * APP业务消息表
 *
 * @author 张志臣
 * @email zhangzhichen@esvtek.com
 * @date 2020-06-10 11:17
 */
public interface BusinessMessageService extends IService<BusinessMessageEntity> {

    /**
     * description 添加消息
     * param [pushMessageForm]
     * return
     * author Administrator
     * createTime 2020/06/10 11:19
     **/
    void insertMessage(PushMessageForm pushMessageForm);

    /**
     * description 获取消息分类
     * param [messageForm]
     * return
     * author Administrator
     * createTime 2020/06/10 16:56
     **/
    List<MessageTypeVO> getMessageType(MessageForm messageForm);

    /**
     * description 获取指定分类的消息列表
     * param [messageForm]
     * return
     * author Administrator
     * createTime 2020/06/10 16:56
     **/
    PageResultVO getMessageList(MessageForm messageForm);

    /**
     * description 删除消息
     * param [messageForm]
     * return
     * author Administrator
     * createTime 2020/06/10 16:56
     **/
    void deleteMessageById(MessageForm messageForm);

    /**
     * description 删除消息分类
     * param [messageForm]
     * return
     * author Administrator
     * createTime 2020/06/10 16:56
     **/
    void deleteMessageByType(MessageForm messageForm);

    /**
     * description 设置消息已读
     * param [messageForm]
     * return
     * author Administrator
     * createTime 2020/06/10 16:56
     **/
    void setAllRead(MessageForm messageForm);

    /**
     * description 获取消息详情
     * param [messageForm]
     * return
     * author Administrator
     * createTime 2020/06/10 16:56
     **/
    MessageDetailVO getMessageDetail(MessageForm messageForm);
}
