package com.esv.freight.app.module.account.controller;

import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.form.LoginForm;
import com.esv.freight.app.module.account.form.ModifyPasswordForm;
import com.esv.freight.app.module.account.service.AppLoginService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 密码Controller
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.controller.DriverPasswordController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/14 16:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/password")
@Slf4j
@Validated
public class DriverPasswordController {

    private NoticeInterface noticeInterface;
    private AppLoginService appLoginService;

    @Autowired
    public DriverPasswordController(NoticeInterface noticeInterface, AppLoginService appLoginService) {
        this.noticeInterface = noticeInterface;
        this.appLoginService = appLoginService;
    }

    /**
     * description 重置密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 16:00
     **/
    @PostMapping("/reset")
    public EResponse reset(@RequestBody(required=false) @Validated(ValidatorInsert.class) LoginForm loginForm) {
/*
        if(resetPasswordForm == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }

        if(!appLoginService.isExistAccount(resetPasswordForm.getPhone())) {
            return EResponse.error(1002, "手机号未注册");
        }

        // 调用通知服务验证短信接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("phone", resetPasswordForm.getPhone());
        reqJson.put("type", "reset_pwd");
        reqJson.put("captcha", resetPasswordForm.getSmsCode());
        log.info(reqJson.toJSONString());
        JSONObject result = noticeInterface.checkSmsCaptcha(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 200) {
            LoginVO loginByPwdVO = appLoginService.loginBySms(resetPasswordForm.getPhone());
            return EResponse.ok(loginByPwdVO);
        }*/

        return EResponse.error(1001, "短信验证码错误或已失效");
    }

    /**
     * description 修改密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 16:00
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorInsert.class) ModifyPasswordForm modifyPasswordFrom) {

        if(modifyPasswordFrom == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }

        if("1234qwer".equals(modifyPasswordFrom.getOldPwd())) {
            return EResponse.error(1001, "原密码错误");
        }

        return EResponse.ok();
    }
}
