package com.esv.freight.app.module.grabbing.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.feign.TmsGrabInterface;
import com.esv.freight.app.feign.TmsOrderInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.grabbing.form.OrderGrabbingQueryForm;
import com.esv.freight.app.module.grabbing.vo.GrabListItemVO;
import com.esv.freight.app.module.grabbing.vo.GrabListVO;
import com.mysql.cj.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 司机找货抢单订单Controller
 * @project: Freight
 * @name: com.esv.freight.app.module.grabbing.controller.GrabController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 13:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/grab")
@Slf4j
@Validated
public class GrabController {

    private AppLoginService appLoginService;
    private TmsGrabInterface tmsGrabInterface;

    @Autowired
    public GrabController(TmsGrabInterface tmsGrabInterface, AppLoginService appLoginService) {
        this.appLoginService = appLoginService;
        this.tmsGrabInterface = tmsGrabInterface;
    }

    /**
     * description 获取全部路线找货列表
     * param param [accessToken]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/24 17:00
     **/
    @PostMapping("/find/list")
    public EResponse getFindGoodsList(@RequestBody(required=false) @Validated(ValidatorList.class) OrderGrabbingQueryForm orderGrabbingQueryForm) {

        appLoginService.checkAccessToken();

        // 调用查询抢单信息列表接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("vehicleTypeMain", orderGrabbingQueryForm.getVehicleTypeMain());
        reqJson.put("vehicleTypeSub", orderGrabbingQueryForm.getVehicleTypeSub());

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getDeliveryProvinceCode())) {
            reqJson.put("deliveryProvinceCode", orderGrabbingQueryForm.getDeliveryProvinceCode());
        }

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getDeliveryCityCode())) {
            reqJson.put("deliveryCityCode", orderGrabbingQueryForm.getDeliveryCityCode());
        }

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getReceiveProvinceCode())) {
            reqJson.put("receiveProvinceCode", orderGrabbingQueryForm.getReceiveProvinceCode());
        }

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getReceiveCityCode())) {
            reqJson.put("receiveCityCode", orderGrabbingQueryForm.getReceiveCityCode());
        }

        reqJson.put("pageNum", orderGrabbingQueryForm.getPageNum());
        reqJson.put("pageSize", orderGrabbingQueryForm.getPageSize());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsGrabInterface.getOrderGrabbingList(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        GrabListVO grabListVO = new GrabListVO();
        JSONObject data = result.getJSONObject("data");
        grabListVO.setPageSize(data.getLong("pageSize"));
        grabListVO.setPageNum(data.getLong("pageNum"));
        grabListVO.setTotal(data.getLong("total"));
        grabListVO.setRecordSize(data.getLong("recordSize"));
        if(grabListVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<GrabListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                GrabListItemVO vo = new GrabListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("orderId"));
                vo.setOrderNo(object.getString("orderNo"));
                vo.setDeliveryProvinceCode(object.getString("deliveryProvinceCode"));
                vo.setDeliveryCityCode(object.getString("deliveryCityCode"));
                vo.setReceiveProvinceCode(object.getString("receiveProvinceCode"));
                vo.setReceiveCityCode(object.getString("receiveCityCode"));
                records.add(vo);
            }

            grabListVO.setRecord(records);
        }
        return EResponse.ok(grabListVO);
    }

    /**
     * description 抢单
     * param param [accessToken]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/24 17:00
     **/
    @PostMapping("/find/grab")
    public EResponse grabOrder(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorUpdate.class) OrderGrabbingQueryForm orderGrabbingQueryForm) {

        appLoginService.checkAccessToken();

        // 调用抢单接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("orderGrabbingId", orderGrabbingQueryForm.getOrderId());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsGrabInterface.grabOrder(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }
}
