package com.esv.freight.app.module.order.form;

import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import java.math.BigDecimal;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.order.form.OrderForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/21 13:00
 * @version:1.0
 */
@Data
public class OrderForm {

    /**
     * 订单id
     */
    @Positive(message = "参数id不合法", groups = {ValidatorUpdate.class})
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class, ValidatorDelete.class})
    private Long id;

    /**
     * 货主id
     */
    @Positive(message = "参数货主ID不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数货主ID不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long goodsOwnerId;

    /**
     * 业务类型
     */
    @Positive(message = "参数业务类型不合法", groups = {ValidatorUpdate.class})
    @Range(min = 1, max = 5, message = "无效的业务类型", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    @NotNull(message = "参数业务类型不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Integer businessType;

    /**
     * 货物类型
     */
    @Positive(message = "参数货物类型不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @Range(min = 1, max = 19, message = "无效的货物类型", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    @NotNull(message = "参数货物类型不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Integer goodsType;

    /**
     * 货物名称编码
     */
    @Positive(message = "参数货物名称不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数货物名称不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Integer goodsNameCode;

    /**
     * 货物明细
     */
    @Length(max = 300, message = "参数货物明细长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class,})
    private String goodsDetail;

    /**
     * 货物订单量
     */
    @Positive(message = "参数货物订单量不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMax(value = "99999999.999", message = "货物订单量不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMin(value = "0.000", message = "货物订单量不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数货物订单量不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private BigDecimal goodsTotalAmount;
    /**
     * 货物单位
     */
    @Range(min = 1, max = 4, message = "无效的货物单位", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数货物单位不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Integer goodsUnit;
    /**
     * 货物单价
     */
    @DecimalMax(value = "999999999.999999", message = "货物单价不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMin(value = "0.000000", message = "货物单价不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数货物单价不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private BigDecimal goodsUnitPrice;

    /**
     * 运费单价（收入）
     */
    @DecimalMax(value = "999999999.999999", message = "运费单价（收入）不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMin(value = "0.000000", message = "运费单价（收入）不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数运费单价（收入）不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class,})
    private BigDecimal freightUnitPriceInput;

    /**
     * 发货地址ID
     */
    @NotNull(message = "参数发货地址ID不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long deliveryAddressId;

    /**
     * 收货地址ID
     */
    @NotNull(message = "参数收货地址ID不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long receiveAddressId;
    /**
     * 要求发货时间
     */
    @NotNull(message = "参数要求发货时间不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long requiredDeliveryTime;
    /**
     * 要求交货时间
     */
    @NotNull(message = "参数要求交货时间不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long requiredReceiveTime;
    /**
     * 车辆类型，主类型
     */
    @Positive(message = "参数车辆类型（主）不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    private Integer vehicleTypeMain;
    /**
     * 车辆类型，子类型
     */
    @Positive(message = "参数车辆类型（子）不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorList.class})
    private Integer vehicleTypeSub;
    /**
     * 车长
     */
    @DecimalMax(value = "999.99", message = "车长不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMin(value = "0.00", message = "车长不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private BigDecimal vehicleLength;
    /**
     * 备注
     */
    @Length(max = 300, message = "参数备注长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
