package com.esv.freight.app.module.complaint.pojo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.complaint.pojo.OwnerComplaintAdvicePojo
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/28 14:00
 * @version:1.0
 */
@Data
public class OwnerComplaintAdvicePojo {

    /**
     * 主键
     */
    private Long id;
    /**
     * 单号
     */
    private String complaintNo;

    /**
     * 类型：1-投诉；2-建议
     */
    private Integer complaintAdvice;

    /**
     * 状态，1-待处理；2-已处理，3-已取消
     */
    private Integer state;

    /**
     * 货主ID
     */
    private Long goodsOwnerId;

    /**
     * 货主姓名
     */
    private String goodsOwnerName;

    /**
     * 运单ID
     */
    private Long waybillId;

    /**
     * 运单号
     */
    private String waybillNo;

    /**
     * 投诉对象，1-司机，2-平台，3-其他
     */
    private Integer complaintObject;

    /**
     * 司机ID
     */
    private Long complaintDriverId;

    /**
     * 司机姓名
     */
    private String complaintDriverName;

    /**
     * 投诉类型，1-运输失效；2-运输质量；3-服务态度；4-其他
     */
    private Integer complaintType;

    /**
     * 投诉内容
     */
    private String complaintContent;

    /**
     * 处罚金额
     */
    private BigDecimal forfeit;

    /**
     * 处理内容
     */
    private String handleContent;

    /**
     * 处理人
     */
    private String handleUserAccount;

    /**
     * 处理时间
     */
    private Date handleTime;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 部门ID
     */
    private Long departmentId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;
}
