package com.esv.freight.app.common.filter;

import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.module.account.CustomToken;
import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

public class CheckCustomToken {

    public static CustomToken getCustomToken(String originalToken) {
        if (StringUtils.isEmpty(originalToken)) {
            throw new EException(601, "无效的Token");
        }

        String[] ss = originalToken.split(",");
        if(ss == null || ss.length != 5) {
            throw new EException(601, "无效的Token");
        }

        CustomToken customToken = new CustomToken();
        customToken.setTenantId(Long.parseLong(ss[0]));
        customToken.setAccessToken(ss[1]);
        customToken.setRefreshToken(ss[2]);
        customToken.setUserId(ss[3]);
        customToken.setAccount(ss[4].substring(0,11));
        return customToken;
    }

    /**
     * 校验token有效性
     */
    public static void check(CustomToken customToken) {
        if (StringUtils.isEmpty(customToken.getAccount()) || StringUtils.isEmpty(customToken.getAccessToken()) || StringUtils.isEmpty(customToken.getRefreshToken())|| StringUtils.isEmpty(customToken.getUserId())) {
            throw new EException(601, "无效的Token");
        }

        if(!isPhone(customToken.getAccount())) {
            throw new EException(601, "无效的Token");
        }
    }

    /**
     * 判断是不是一个合法的手机号码
     */
    private static boolean isPhone(String phoneNum) {
        if (phoneNum == null || phoneNum.trim().length() == 0) {
            return false;
        }

        Pattern PHONE = Pattern.compile("^((1[0-9][0-9]))\\d{8}$");

        return PHONE.matcher(phoneNum).matches();
    }
}
