package com.esv.freight.app.module.waybill.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 运单列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.waybill.vo.WaybillListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class WaybillListItemVO {

    /**
     * 	运单ID
     */
    private Long id;

    /**
     * 	运单号
     */
    private String waybillNO;

    /**
     * 	订单号
     */
    private String orderNO;

    /**
     * 运单状态
     */
    private Integer waybillState;

    /**
     * 发货城市编码
     */
    private String deliveryCity;

    /**
     * 收货城市编码
     */
    private String receiveCity;

    /**
     * 货物名称编码
     */
    private Integer goodsName;

    /**
     * 货物订单量
     */
    private BigDecimal goodsTotalAmount;

    /**
     * 货物单位
     */
    private String goodsUnit;

    /**
     * 要求发货时间
     */
    private Date requiredDeliveryTime;

    /**
     * 要求交货时间
     */
    private Date requiredReceiveTime;

    /**
     * 运单生成时间
     */
    private Date createTime;

    /**
     * 执行车辆
     */
    private String vehicleNum;
}
