package com.esv.freight.app.module.account.vo;

import lombok.Data;

/**
 * @description: 货主账号详情VO
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.login.vo.OwnerAccountDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 17:00
 * @version:1.0
 */
@Data
public class OwnerAccountDetailVO {

    // 账号ID
    private String id;

    // 登录帐号，货主手机号
    private String account;

    // 创建来源：1-平台创建、2-自行注册
    private String sourceType;

    // 货主帐号审核状态：0-待审核、1-审核成功，2-审核失败，APP自行注册需要平台审核
    private Integer auditStatus;

    // 货主类型：1-个人、2-企业
    private Integer ownerType;

    // 姓名
    private String name;

    // 身份证号码
    private String idCard;

    // 身份证有效期 格式yyyy.MM.dd，或长期
    private String idCardExpireDate;

    // 身份证正面图片ULR
    private String idCardFileFrontUrl;

    // 身份证反面图片ULR
    private String idCardFileBackUrl;

    // 省份代码
    private String provinceCode;

    // 市代码
    private String cityCode;

    // 区县代码
    private String districtCode;

    // 详细地址
    private String detailAddress;

    // 客户名称
    private String ownerFullName;

    // 客户简称
    private String ownerBriefName;

    // 统一社会信用代码
    private String uniCreditCode;

    // 营业期限
    private String creditExpireDate;

    // 营业执照正本ULR
    private String creditOriginalUrl;

    // 营业执照副本ULR
    private String creditCopyUrl;

    // 企业法人姓名
    private String legalPerson;

    // 企业法人手机号
    private String legalPhone;
}
