package com.esv.freight.app.module.order.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 订单列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.order.vo.OrderListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class OrderListItemVO {

    /**
     * 	订单ID
     */
    private Long id;

    /**
     * 	订单号
     */
    private String orderNo;

    /**
     * 订单状态.
     */
    private Integer orderState;

    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 发货城市编码
     */
    private String deliveryCityCode;

    /**
     * 收货城市编码
     */
    private String receiveCityCode;

    /**
     * 业务类型
     */
    private Integer businessType;

    /**
     * 货物类型
     */
    private Integer goodsType;

    /**
     * 货物名称
     */
    private Integer goodsName;

    /**
     * 货物名称编码
     */
    private Integer goodsNameCode;

    /**
     * 货物明细
     */
    private String goodsDetail;

    /**
     * 货物订单量
     */
    private BigDecimal totalGoodsAmount;

    /**
     * 货物剩余订单量
     */
    private BigDecimal remainingGoodsAmount;

    /**
     * 货物单位
     */
    private Integer goodsUnit;

    /**
     * 货物单价
     */
    private BigDecimal goodsUnitPrice;

    /**
     * 运费单价（收入）
     */
    private BigDecimal freightUnitPriceInput;

    /**
     * 要求发货时间
     */
    private Long requiredDeliveryTime;

    /**
     * 要求交货时间
     */
    private Long requiredReceiveTime;

    /**
     * 订单创建时间
     */
    private Long createTime;

    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 客户下单时间
     */
    private Long placeOrderTime;
}
