package com.esv.freight.app.module.address.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.app.module.address.form.ReceiveAddressForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 15:00
 * @version:1.0
 */
@Data
public class ReceiveAddressForm {

    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class, ValidatorDetail.class})
    private Long id;

    @NotNull(message = "参数ownerId不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long ownerId;

    @Length(max = 50, message = "参数addressName长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数addressName不能为空", groups = {ValidatorInsert.class})
    private String addressName;

    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数provinceCode不能为空", groups = {ValidatorInsert.class})
    private String provinceCode;

    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数cityCode不能为空", groups = {ValidatorInsert.class})
    private String cityCode;

    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数districtCode不能为空", groups = {ValidatorInsert.class})
    private String districtCode;

    @Length(max = 50, message = "参数detailAddress长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数detailAddress不能为空", groups = {ValidatorInsert.class})
    private String detailAddress;

    @Length(max = 20, message = "参数deliverer长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数deliverer不能为空", groups = {ValidatorInsert.class})
    private String receiver;

    @Length(min = 11, max = 11, message = "参数delivererPhone长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数delivererPhone不能为空", groups = {ValidatorInsert.class})
    private String receiverPhone;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
