package com.esv.freight.app.module.account.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 账号是否存在VO
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.account.vo.AccountExistVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/06 10:00
 * @version:1.0
 */
@Data
public class AccountExistVO {

    /**
     * 帐号状态：1-账号已存在、2-账号不存在
     */
    private Integer accountStatus;

    /**
     * 承运商帐号ID
     */
    private Long carrierId;

    /**
     * 承运商名称
     */
    private String carrierName;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
