package com.esv.freight.app.module.account.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.app.module.account.entity.AppLoginEntity;
import com.esv.freight.app.module.account.form.RefreshTokenForm;
import com.esv.freight.app.module.account.vo.LoginVO;

/**
 * APP用户登录信息表
 *
 * @author 张志臣
 * @email zhangzhichen@esvtek.com
 * @date 2020-04-15 10:00
 */
public interface AppLoginService extends IService<AppLoginEntity> {

    /**
     * description 账号登录
     * param [phone]
     * return LoginVO
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    LoginVO login(String phone);

    /**
     * description 账号登出
     * param [accessToken]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    void logout(String accessToken);

    /**
     * description 账号停用
     * param [phone]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/05/06 16:48
     **/
    void stopUsing(String phone);

    /**
     * description 刷新token
     * param [accessToken, refreshTokenForm]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    LoginVO refreshToken(String accessToken, RefreshTokenForm refreshTokenForm);

    /**
     * description 判断accessToken是否有效
     * param [accessToken]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    void checkAccessToken();

    /**
     * description 判断refreshToken是否有效
     * param [refreshToken]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    boolean isInvalidRefreshToken(String refreshToken);
}