package com.esv.freight.app.module.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.app.common.component.RedisComponent;
import com.esv.freight.app.common.component.TokenComponent;
import com.esv.freight.app.common.constants.AccountConstants;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.module.account.dao.AppLoginDao;
import com.esv.freight.app.module.account.entity.AppLoginEntity;
import com.esv.freight.app.module.account.form.RefreshTokenForm;
import com.esv.freight.app.module.account.pojo.DriverAccountInfoPojo;
import com.esv.freight.app.module.account.pojo.OwnerAccountInfoPojo;
import com.esv.freight.app.module.account.pojo.TokenInfoPojo;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.account.vo.LoginVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

@Service("appLoginService")
public class AppLoginServiceImpl extends ServiceImpl<AppLoginDao, AppLoginEntity> implements AppLoginService {

    @Autowired
    private TokenComponent tokenComponent;

    @Override
    public LoginVO driverLogin(DriverAccountInfoPojo driverAccountInfoPojo) {
        // 1:初始化Token
        TokenInfoPojo tokenInfoPojo = new TokenInfoPojo();
        BeanUtils.copyProperties(driverAccountInfoPojo, tokenInfoPojo);
        tokenInfoPojo.setAccountId(driverAccountInfoPojo.getId());
        this.tokenComponent.generateTokenInfo(tokenInfoPojo);

        // 2:保存或更新登录信息
        AppLoginEntity record = this.baseMapper.selectOne(new QueryWrapper<AppLoginEntity>().lambda()
                .eq(AppLoginEntity::getAccountType, tokenInfoPojo.getAccountType())
                .eq(AppLoginEntity::getPhone, tokenInfoPojo.getAccount()));
        AppLoginEntity appLoginEntity = new AppLoginEntity();
        BeanUtils.copyProperties(tokenInfoPojo, appLoginEntity);
        appLoginEntity.setLoginStatus(AccountConstants.ACCOUNT_STATUS_LOGIN);
        appLoginEntity.setPhone(tokenInfoPojo.getAccount());
        appLoginEntity.setLoginTime(new Date(tokenInfoPojo.getLoginTime()));
        appLoginEntity.setRefreshTime(appLoginEntity.getLoginTime());
        appLoginEntity.setAccessTokenValidTime(new Date(tokenInfoPojo.getAccessTokenValidTime()));
        appLoginEntity.setRefreshTokenValidTime(new Date(tokenInfoPojo.getRefreshTokenValidTime()));

        if (null == record) {
            this.baseMapper.insert(appLoginEntity);
        } else {
            appLoginEntity.setId(record.getId());
            this.baseMapper.updateById(appLoginEntity);
        }

        // 3:返回Token
        LoginVO loginVO = new LoginVO();
        BeanUtils.copyProperties(tokenInfoPojo, loginVO);
        return loginVO;
    }

    @Override
    public LoginVO ownerLogin(OwnerAccountInfoPojo ownerAccountInfoPojo) {
        // 1:初始化Token
        TokenInfoPojo tokenInfoPojo = new TokenInfoPojo();
        BeanUtils.copyProperties(ownerAccountInfoPojo, tokenInfoPojo);
        tokenInfoPojo.setAccountId(ownerAccountInfoPojo.getId());
        this.tokenComponent.generateTokenInfo(tokenInfoPojo);

        // 2:保存或更新登录信息
        AppLoginEntity record = this.baseMapper.selectOne(new QueryWrapper<AppLoginEntity>().lambda()
                .eq(AppLoginEntity::getAccountType, tokenInfoPojo.getAccountType())
                .eq(AppLoginEntity::getPhone, tokenInfoPojo.getAccount()));
        AppLoginEntity appLoginEntity = new AppLoginEntity();
        BeanUtils.copyProperties(tokenInfoPojo, appLoginEntity);
        appLoginEntity.setLoginStatus(AccountConstants.ACCOUNT_STATUS_LOGIN);
        appLoginEntity.setPhone(tokenInfoPojo.getAccount());
        appLoginEntity.setLoginTime(new Date(tokenInfoPojo.getLoginTime()));
        appLoginEntity.setRefreshTime(appLoginEntity.getLoginTime());
        appLoginEntity.setAccessTokenValidTime(new Date(tokenInfoPojo.getAccessTokenValidTime()));
        appLoginEntity.setRefreshTokenValidTime(new Date(tokenInfoPojo.getRefreshTokenValidTime()));

        if (null == record) {
            this.baseMapper.insert(appLoginEntity);
        } else {
            appLoginEntity.setId(record.getId());
            this.baseMapper.updateById(appLoginEntity);
        }

        // 3:返回Token
        LoginVO loginVO = new LoginVO();
        BeanUtils.copyProperties(tokenInfoPojo, loginVO);
        return loginVO;
    }

    @Override
    public void logout() {
        TokenInfoPojo tokenInfoPojo = this.tokenComponent.getTokenInfo();
        clearLoginInfo(tokenInfoPojo);
    }

    @Override
    public void stopUsing(String phone, Integer type) {
        TokenInfoPojo tokenInfoPojo = this.tokenComponent.getTokenInfo(phone, type);
        clearLoginInfo(tokenInfoPojo);
    }

    private void clearLoginInfo(TokenInfoPojo tokenInfoPojo) {
        AppLoginEntity record = this.baseMapper.selectOne(new QueryWrapper<AppLoginEntity>().lambda()
                .eq(AppLoginEntity::getAccountType, tokenInfoPojo.getAccountType())
                .eq(AppLoginEntity::getPhone, tokenInfoPojo.getAccount()));

        AppLoginEntity appLoginEntity = new AppLoginEntity();
        BeanUtils.copyProperties(tokenInfoPojo, appLoginEntity);
        appLoginEntity.setLoginStatus(AccountConstants.ACCOUNT_STATUS_LOGOUT);
        appLoginEntity.setAccessToken("");
        appLoginEntity.setRefreshToken("");
        appLoginEntity.setLogoutTime(new Date());
        appLoginEntity.setAccessTokenValidTime(new Date());
        appLoginEntity.setRefreshTokenValidTime(new Date());
        appLoginEntity.setId(record.getId());
        this.baseMapper.updateById(appLoginEntity);

        //清缓存
        tokenComponent.cleatTokenInfoCache(tokenInfoPojo);
    }

    @Override
    public LoginVO refreshToken(RefreshTokenForm refreshTokenForm) {

        TokenInfoPojo pojo = this.tokenComponent.getTokenInfo();

        TokenInfoPojo tokenInfoPojo = new TokenInfoPojo();
        BeanUtils.copyProperties(pojo, tokenInfoPojo);
        this.tokenComponent.refreshTokenInfo(tokenInfoPojo);

        AppLoginEntity record = this.baseMapper.selectOne(new QueryWrapper<AppLoginEntity>().lambda()
                .eq(AppLoginEntity::getAccountType, tokenInfoPojo.getAccountType())
                .eq(AppLoginEntity::getPhone, tokenInfoPojo.getAccount()));

        AppLoginEntity appLoginEntity = new AppLoginEntity();
        BeanUtils.copyProperties(tokenInfoPojo, appLoginEntity);
        appLoginEntity.setLoginStatus(AccountConstants.ACCOUNT_STATUS_LOGIN);
        appLoginEntity.setPhone(tokenInfoPojo.getAccount());
        appLoginEntity.setRefreshTime(new Date(tokenInfoPojo.getRefreshTime()));
        appLoginEntity.setAccessTokenValidTime(new Date(tokenInfoPojo.getAccessTokenValidTime()));
        appLoginEntity.setRefreshTokenValidTime(new Date(tokenInfoPojo.getRefreshTokenValidTime()));
        appLoginEntity.setId(record.getId());
        this.baseMapper.updateById(appLoginEntity);

        //数据转换
        LoginVO loginVO = new LoginVO();
        BeanUtils.copyProperties(tokenInfoPojo, loginVO);
        return loginVO;
    }

    @Override
    public AppLoginEntity getAccountByPhone(String phone) {
        QueryWrapper<AppLoginEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", phone);
        return this.baseMapper.selectOne(queryWrapper);
    }
}
