package com.esv.freight.app.module.account;

import com.esv.freight.app.common.exception.EException;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @description: 自定义token
 * @project: Freight
 * @name: com.esv.freight.app.module.account.CustomToken
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/27 14:00
 * @version:1.0
 */
@Data
public class CustomToken {

    /**
     * token格式：
     * 租户ID,访问toekn,刷新token,用户ID,登录账号
     * String tokenTest = "XXX,XXX,XXX,XXX,XXX"
     * String tokenTest = "test001,607083d2ab8d4455adf6c1863eda8944,607083d2ab8d4455adf6c1863eda8944,7,15040196792";
     */

    /**
     * 用户登录账号
     */
    private String account;

    /**
     * 访问token
     */
    private String accessToken;

    /**
     * 刷新token
     */
    private String refreshToken;

    /**
     * 用户ID(货主APP访问对应货主ID、司机APP访问对应司机ID)
     */
    private String userId;

    /**
     * 租户ID(每个租户下的APP固定传入)
     */
    private Long tenantId;
}
