package com.esv.freight.app.module.waybill.pojo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description:
 * @project: app-service
 * @name: com.esv.freight.app.module.account.pojo.PayDataListItemPojo
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/08 13:54
 * @version:1.0
 */
@Data
public class PayDataListItemPojo {

    /**
     * 主键
     */
    private Long id;

    /**
     * 运单ID
     */
    private String waybillId;

    /**
     * 运单号
     */
    private String waybillNo;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 运单生成时间
     */
    private Date waybillTime;

    /**
     * 账单ID
     */
    private Long billId;

    /**
     * 账单号
     */
    private String billNo;

    /**
     * 运单状态
     */
    private Integer waybillState;

    /**
     * 应付对账状态:0-未对账;1-核实中;2-已对账;3-已支付;4-已开票;5-支付失败
     */
    private Integer payVerifyStatus;

    /**
     * 车辆ID
     */
    private Long vehicleId;

    /**
     * 车牌号
     */
    private String vehicleLicenseNo;

    /**
     * 所属承运商ID
     */
    private String carrierId;

    /**
     * 所属承运商名称
     */
    private String carrierName;

    /**
     * 司机ID
     */
    private Long driverId;

    /**
     * 司机名称
     */
    private String driverName;

    /**
     * 结算对象 个人、某个承运商
     */
    private Long settlementClient;

    /**
     * 货物名称编码
     */
    private String goodsNameCode;

    /**
     * 货物名称
     */
    private String goodsName;

    /**
     * 货物单位 1-吨；2-件；3-立方；4-平方
     */
    private Integer goodsUnit;

    /**
     * 交货量
     */
    private BigDecimal goodsDeliveryAmount;

    /**
     * 运费单价
     */
    private BigDecimal unitPrice;

    /**
     * 运费
     */
    private BigDecimal freightPrice;

    /**
     * 亏吨
     */
    private BigDecimal less = BigDecimal.ZERO;

    /**
     * 涨吨
     */
    private BigDecimal more = BigDecimal.ZERO;

    /**
     * 预付款
     */
    private BigDecimal prepay = BigDecimal.ZERO;

    /**
     * 油卡费
     */
    private BigDecimal gasoline = BigDecimal.ZERO;

    /**
     * 保险费
     */
    private BigDecimal premium = BigDecimal.ZERO;

    /**
     * 信息费
     */
    private BigDecimal info = BigDecimal.ZERO;

    /**
     * 内保费
     */
    private BigDecimal inprotect = BigDecimal.ZERO;

    /**
     * 个税
     */
    private BigDecimal individual = BigDecimal.ZERO;

    /**
     * 罚款
     */
    private BigDecimal punish = BigDecimal.ZERO;

    /**
     * 欠款
     */
    private BigDecimal debt = BigDecimal.ZERO;

    /**
     * 装卸费
     */
    private BigDecimal handling = BigDecimal.ZERO;

    /**
     * 奖金
     */
    private BigDecimal bonus = BigDecimal.ZERO;

    /**
     * 补贴费
     */
    private BigDecimal subsidy = BigDecimal.ZERO;

    /**
     * 抹零
     */
    private BigDecimal smallchange = BigDecimal.ZERO;

    /**
     * 总计费用(元)
     */
    private BigDecimal totalMoney;

    /**
     * 创建时间
     */
    private Date createTime;
}
