package com.esv.freight.app.module.bill.form;

import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.bill.form.OwnerPayForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/03 16:50
 * @version:1.0
 */
@Data
public class OwnerPayForm {

    /**
     * 账号ID
     */
    @Positive(message = "参数userId不合法", groups = {ValidatorInsert.class})
    @NotNull(message = "参数userId不能为空", groups = {ValidatorInsert.class})
    private Long customerId;

    /**
     * 账单号
     */
    @NotBlank(message = "参数billNo不能为空", groups = {ValidatorInsert.class})
    private String billNo;

    /**
     * 交易金额
     */
    @Positive(message = "参数txnAmt不合法", groups = {ValidatorInsert.class})
    @NotNull(message = "参数txnAmt不能为空", groups = {ValidatorInsert.class})
    private BigDecimal txnAmt;
}
