package com.esv.freight.app.common.filter;

import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.feign.CarrierInterface;
import com.esv.freight.app.feign.DriverInterface;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.CustomToken;
import com.esv.freight.app.module.account.service.AppLoginService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.regex.Pattern;

public class CheckCustomToken {

    public static CustomToken getCustomToken(String originalToken) {
        if (StringUtils.isEmpty(originalToken)) {
            throw new EException(601, "无效的Token");
        }

        String[] ss = originalToken.split(",");
        if(ss == null || ss.length != 5) {
            throw new EException(601, "无效的Token");
        }

        CustomToken customToken = new CustomToken();
        customToken.setTenantId(Long.parseLong(ss[0]));
        customToken.setAccessToken(ss[1]);
        customToken.setRefreshToken(ss[2]);
        customToken.setUserId(ss[3]);
        if(!StringUtils.isEmpty(ss[4]) && ss[4].length() >= 11) {
            customToken.setAccount(ss[4].substring(0,11));
        }
        else {
            customToken.setAccount(null);
        }

        return customToken;
    }

    /**
     * 校验token有效性
     */
    public static void check(CustomToken customToken, String url) {

        Long tenantId = customToken.getTenantId();
        // TODO 判断租户ID是否正确，如果不存在此租户，直接返回，目前暂定租户名"100100100"
        if(tenantId != 1L) {
            throw new EException(401, "没有访问权限");
        }

        if("/app/ownerBackend/account/login/loginByPwd".equals(url) ||
                "/app/ownerBackend/account/login/loginBySms".equals(url) ||
                "/app/ownerBackend/password/reset".equals(url) ||
                "/app/driverBackend/account/login/loginBySms".equals(url) ||
                "/app/driverBackend/account/login/loginByPwd".equals(url) ||
                "/app/driverBackend/account/carrier/list".equals(url) ||
                "/app/driverBackend/account/login/check/phone".equals(url) ||
                "/app/driverBackend/password/reset".equals(url)) {

            //此类接口不校验token
            return;
        }

        // 检验token是否为空
        if (StringUtils.isEmpty(customToken.getAccount()) || StringUtils.isEmpty(customToken.getAccessToken()) || StringUtils.isEmpty(customToken.getRefreshToken())) {
            throw new EException(601, "无效的Token");
        }

        // 校验手机号格式是否正确
        if(!isPhone(customToken.getAccount())) {
            throw new EException(601, "无效的Token");
        }

        if("/app/ownerBackend/account/detail".equals(url) ||
                "/app/driverBackend/account/detail".equals(url)) {
            //此类接口不校验userId
            return;
        }

        // 校验userId是否为空
        if(StringUtils.isEmpty(customToken.getUserId())) {
            throw new EException(601, "无效的Token");
        }
    }

    /**
     * 判断是不是一个合法的手机号码
     */
    private static boolean isPhone(String phoneNum) {
        if (phoneNum == null || phoneNum.trim().length() == 0) {
            return false;
        }

        Pattern PHONE = Pattern.compile("^((1[0-9][0-9]))\\d{8}$");

        return PHONE.matcher(phoneNum).matches();
    }
}
