package com.esv.freight.app.common.component;

import com.esv.freight.app.common.constants.AccountConstants;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.common.response.ECode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * @description: 协议组件
 * @project: app-service
 * @name: com.esv.freight.app.common.component.ProtocolComponent
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/14 15:58
 * @version:1.0
 */
@Component
@Slf4j
public class ProtocolComponent {

    /**
     * description 校验Http请求的Header
     *      Map<String,String> map = new HashMap<>();
     *      map.put("requestSource", "2"); // 终端类型：2-Android端、3-iOS端
     *      map.put("Union-Authorization", AppConfig.getInstance().getToken()); // token
     *      map.put("osType", osType); // 客户端操作系统名称
     *      map.put("osVer", osVer); // 客户端操作系统版本
     *      map.put("mobileId", mobileId); // 手机唯一标识
     *      map.put("cVer", cVer); // 客户端版本
     *      map.put("accountType", "1"); // 帐号身份类型：1-司机、2-货主
     * param [request]
     * return void
     * author Administrator
     * createTime 2020/05/14 16:00
     **/
    public void checkReqHeader(HttpServletRequest request) throws EException {
        if (!String.valueOf(AccountConstants.APP_TYPE_ANDROID).equals(request.getHeader("requestSource"))
                && !String.valueOf(AccountConstants.APP_TYPE_IOS).equals(request.getHeader("requestSource"))) {
            throw new EException(ECode.PROTOCOL_ILLEGAL.code(), "请求头[requestSource]不符合协议");
        }
        if (StringUtils.isBlank(request.getHeader("osType"))) {
            throw new EException(ECode.PROTOCOL_ILLEGAL.code(), "请求头[osType]不符合协议");
        }
        if (StringUtils.isBlank(request.getHeader("osVer"))) {
            throw new EException(ECode.PROTOCOL_ILLEGAL.code(), "请求头[osVer]不符合协议");
        }
        if (StringUtils.isBlank(request.getHeader("mobileId"))) {
            throw new EException(ECode.PROTOCOL_ILLEGAL.code(), "请求头[mobileId]不符合协议");
        }
        if (StringUtils.isBlank(request.getHeader("cVer"))) {
            throw new EException(ECode.PROTOCOL_ILLEGAL.code(), "请求头[cVer]不符合协议");
        }
        if (!String.valueOf(AccountConstants.ACCOUNT_TYPE_DRIVER).equals(request.getHeader("accountType"))
                && !String.valueOf(AccountConstants.ACCOUNT_TYPE_GOODS_OWNER).equals(request.getHeader("accountType"))) {
            throw new EException(ECode.PROTOCOL_ILLEGAL.code(), "请求头[accountType]不符合协议");
        }
    }

}
