package com.esv.freight.app.common.filter;

import com.esv.freight.app.common.component.ProtocolComponent;
import com.esv.freight.app.common.component.TokenComponent;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.wrapper.RestRequestWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 * @description: 权限过滤器
 * @project: app-service
 * @name: com.esv.freight.app.common.filter.AuthFilter
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 15:02
 * @version:1.0
 */
@Slf4j
@RefreshScope
public class AuthFilter implements Filter {

    /**
     * 不需要TOKEN校验的URL
     **/
    private static final String[] NOT_TOKEN_URL = new String[]{"/app/ownerBackend/account/login/loginBySms", "/app/ownerBackend/account/login/loginByPwd",
        "/app/driverBackend/account/login/loginBySms", "/app/driverBackend/account/login/loginByPwd"};

    @Autowired
    private ProtocolComponent protocolComponent;

    @Autowired
    private TokenComponent tokenComponent;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        RestRequestWrapper requestWrapper = new RestRequestWrapper((HttpServletRequest)servletRequest);

        // 请求头协议校验
        try {
            protocolComponent.checkReqHeader(requestWrapper);
        } catch (EException e) {
            this.errorResponse(EResponse.error(e.getCode(), e.getMessage()), response);
            return;
        }

        // 校验token
        String url = requestWrapper.getRequestURI();
        Boolean isCheckToken = true;
        for (int i = 0; i < NOT_TOKEN_URL.length; i++) {
            if (NOT_TOKEN_URL[i].equals(url)) {
                isCheckToken = false;
                break;
            }
        }
        if (isCheckToken) {
            String token = request.getHeader("Union-Authorization");
            try {
                tokenComponent.checkAccessToken(token);
            } catch (EException e) {
                this.errorResponse(EResponse.error(e.getCode(), e.getMessage()), response);
                return;
            }
        }

        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {

    }

    private void errorResponse(EResponse eResponse, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter(response.getOutputStream(), "UTF-8");
            writer = new PrintWriter(osw, true);
            writer.write(eResponse.toString());
            writer.flush();
            osw.close();
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        } finally {
            if (null != writer) {
                writer.close();
            }
            if (null != osw) {
                try {
                    osw.close();
                } catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }
}
