package com.esv.freight.app.module.waybill.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 运单列表itemVO
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.waybill.vo.WaybillListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class WaybillListItemVO {

    /**
     * 主键
     */
    private Long id;
    /**
     * 车辆ID
     */
    private Long vehicleId;
    /**
     * 车牌号
     */
    private String vehicleLicenseNo;

    /**
     * 运单号，YD+”8位日期“+”6位序号“
     */
    private String waybillNo;
    /**
     * 运单状态.1-装货中；2-运输中；3-已交货；4-已签收；5-已回单；6-已作废
     */
    private Integer waybillState;
    /**
     * 发货策略 1-平台代发货；2-货主直接发货
     */
    private Integer deliveryStrategy;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 订单号
     * D+"8位日期“+”6位序号“
     */
    private String orderNo;

    /**
     * 货主id
     */
    private Long goodsOwnerId;
    /**
     * 货主姓名
     */
    private String goodsOwnerName;

    /**
     * 发货城市编码
     */
    private String deliveryCityCode;

    /**
     * 收货城市编码
     */
    private String receiveCityCode;
    /**
     * 司机ID
     */
    private Long driverId;
    /**
     * 司机名称
     */
    private String driverName;
    /**
     * 司机电话
     */
    private String driverPhone;

    /**
     * 结算对象类型
     */
    private String settlementType;

    /**
     * 所属承运商ID
     */
    private Long carrierId;
    /**
     * 所属承运商名称
     */
    private String carrierName;
    /**
     * 业务类型 1-干线普通运输；2-城市配送；3-农村配送；4-集装箱运输；5-其他
     */
    private Integer businessType;
    /**
     * 货物类型
     */
    private Integer goodsType;
    /**
     * 货物名称编码
     */
    private Integer goodsNameCode;
    /**
     * 货物名称
     */
    private String goodsName;

    /**
     * 货物订单量
     */
    private BigDecimal goodsAmount;
    /**
     * 运费单价（支出）
     */
    private BigDecimal freightUnitPriceOutput;

    /**
     * 发货单据ID
     */
    private Long deliveryEvidenceId;

    /**
     * 实际发货时间
     */
    private Date deliveryTime;
    /**
     * 实际发货运单量
     */
    private BigDecimal deliveryGoodsAmount;

    /**
     * 收货单据ID
     */
    private Long receiveEvidenceId;

    /**
     * 实际收货时间
     */
    private Date receiveTime;

    /**
     * 实际收货运单量
     */
    private BigDecimal receiveGoodsAmount;

    /**
     * 应付结算状态
     */
    private Integer payVerifyState;

    /**
     * 货物单位。1-吨；2-件；3-立方；4-平方
     */
    private Integer goodsUnit;

    /**
     * 运费单价（收入）
     */
    private BigDecimal freightUnitPriceInput;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 要求发货时间
     */
    private Date requiredDeliveryTime;

    /**
     * 要求交货时间
     */
    private Date requiredReceiveTime;
}
