package com.esv.freight.app.module.vehicle.form;

import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.vehicle.form.VehicleForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/28 16:00
 * @version:1.0
 */
@Data
public class VehicleForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class})
    private Long id;
    /**
     * 承运商帐号ID
     */
    @NotNull(message = "参数carrierId不能为空", groups = {ValidatorInsert.class})
    private Long carrierId;
    /**
     * 车牌号
     */
    @Length(min = 7, max = 8, message = "参数licenseNumber长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数licenseNumber不能为空", groups = {ValidatorInsert.class})
    private String licenseNumber;
    /**
     * 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
     */
    @Range(min = 1, max = 3, message = "参数licenseType不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数licenseType不能为空", groups = {ValidatorInsert.class})
    private Integer licenseType;
    /**
     * 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
     */
    @Range(min = 0, max = 9, message = "参数licenseColor不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数licenseColor不能为空", groups = {ValidatorInsert.class})
    private Integer licenseColor;
    /**
     * 车辆类型(字典表)
     */
    @NotNull(message = "参数vehicleType不能为空", groups = {ValidatorInsert.class})
    private Integer vehicleType;
    /**
     * 二级车辆类型(字典表)
     */
    @NotNull(message = "参数vehicleType2不能为空", groups = {ValidatorInsert.class})
    private Integer vehicleType2;
    /**
     * 车辆长度(单位毫米)
     */
    @Range(min = 1000, max = 50000, message = "参数vehicleLength不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数vehicleLength不能为空", groups = {ValidatorInsert.class})
    private Integer vehicleLength;
    /**
     * 车辆宽度(单位毫米)
     */
    @Range(min = 1000, max = 5000, message = "参数vehicleWidth不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数vehicleWidth不能为空", groups = {ValidatorInsert.class})
    private Integer vehicleWidth;
    /**
     * 车辆高度(单位毫米)
     */
    @Range(min = 1000, max = 5000, message = "参数vehicleHeight不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数vehicleHeight不能为空", groups = {ValidatorInsert.class})
    private Integer vehicleHeight;
    /**
     * 车辆所属(字典表)：1-自有车、2-外协车
     */
    @Range(min = 1, max = 2, message = "参数vehicleBelong不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数vehicleBelong不能为空", groups = {ValidatorInsert.class})
    private Integer vehicleBelong;
    /**
     * 年审日期
     */
    @Length(max = 20, message = "参数yearAuditDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String yearAuditDate;
    /**
     * 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
     */
    @Range(min = 0, max = 10, message = "参数energyType不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数energyType不能为空", groups = {ValidatorInsert.class})
    private Integer energyType;
    /**
     * 行驶证档案编号
     */
    @Length(max = 20, message = "参数vehicleLicenseNumber长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleLicenseNumber不能为空", groups = {ValidatorInsert.class})
    private String vehicleLicenseNumber;
    /**
     * 核定载质量(吨)
     */
    @DecimalMax(value = "9999.99", message = "参数loadCapacity不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMin(value = "1.00", message = "参数loadCapacity不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数loadCapacity不能为空", groups = {ValidatorInsert.class})
    private BigDecimal loadCapacity;
    /**
     * 总质量(吨)
     */
    @DecimalMax(value = "9999.99", message = "参数totalMass不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMin(value = "1.00", message = "参数totalMass不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private BigDecimal totalMass;
    /**
     * 整备质量(吨)
     */
    @DecimalMax(value = "9999.99", message = "参数unladenMass不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @DecimalMin(value = "1.00", message = "参数unladenMass不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private BigDecimal unladenMass;
    /**
     * 车辆所有人
     */
    @Length(max = 20, message = "参数vehicleOwner长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleOwner不能为空", groups = {ValidatorInsert.class})
    private String vehicleOwner;
    /**
     * 车辆所有人代码：企业-统一社会信用代码，个人-身份证号码
     */
    @Length(max = 20, message = "参数vehicleOwnerCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleOwnerCode不能为空", groups = {ValidatorInsert.class})
    private String vehicleOwnerCode;
    /**
     * 使用性质
     */
    @Length(max = 20, message = "参数useNature长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String useNature;
    /**
     * 注册日期
     */
    @Length(max = 20, message = "参数registerDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String registerDate;
    /**
     * 车辆识别代码
     */
    @Length(max = 20, message = "参数vin长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String vin;
    /**
     * 品牌型号
     */
    @Length(max = 20, message = "参数brandModel长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String brandModel;
    /**
     * 发动机号
     */
    @Length(max = 20, message = "参数engineNumber长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String engineNumber;
    /**
     * 发证日期
     */
    @Length(max = 20, message = "参数vehicleLicenseIssuedDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String vehicleLicenseIssuedDate;
    /**
     * 检验有效期至
     */
    @Length(max = 20, message = "参数vehicleLicenseExpireDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String vehicleLicenseExpireDate;
    /**
     * 发证机关
     */
    @Length(max = 50, message = "参数vehicleLicenseIssueDepartment长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String vehicleLicenseIssueDepartment;
    /**
     * 道路运输证号
     */
    @Length(max = 50, message = "参数roadCertificateNumber长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String roadCertificateNumber;
    /**
     * 经营许可证号
     */
    @Length(max = 20, message = "参数businessLicenseNumber长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String businessLicenseNumber;
    /**
     * 经营许可证有效期至
     */
    @Length(max = 20, message = "参数businessLicenseExpireDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String businessLicenseExpireDate;
    /**
     * 车籍地-省份代码
     */
    @Length(max = 6, message = "参数vehicleProvinceCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleProvinceCode不能为空", groups = {ValidatorInsert.class})
    private String vehicleProvinceCode;
    /**
     * 车籍地-市代码
     */
    @Length(max = 6, message = "参数vehicleCityCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleCityCode不能为空", groups = {ValidatorInsert.class})
    private String vehicleCityCode;
    /**
     * 车籍地-区县代码
     */
    @Length(max = 6, message = "参数vehicleDistrictCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleDistrictCode不能为空", groups = {ValidatorInsert.class})
    private String vehicleDistrictCode;
    /**
     * 是否开通ETC：1-已开通、2-未开通、3-未知
     */
    @Pattern(regexp = "[12]", message = "参数etc不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String etc;
    /**
     * 车头照片URL
     */
    @Length(max = 200, message = "参数vehicleHeadUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String vehicleHeadUrl;
    /**
     * 人车合照URL
     */
    @Length(max = 200, message = "参数vehicleHeadPersonUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String vehicleHeadPersonUrl;
    /**
     * 行驶证正面URL
     */
    @Length(max = 200, message = "参数vehicleLicenseFrontUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleLicenseFrontUrl不能为空", groups = {ValidatorInsert.class})
    private String vehicleLicenseFrontUrl;
    /**
     * 行驶证背面URL
     */
    @Length(max = 200, message = "参数vehicleLicenseBackUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数vehicleLicenseBackUrl不能为空", groups = {ValidatorInsert.class})
    private String vehicleLicenseBackUrl;
    /**
     * 道路运输证正面URL
     */
    @Length(max = 200, message = "参数roadCertificateFrontUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数roadCertificateFrontUrl不能为空", groups = {ValidatorInsert.class})
    private String roadCertificateFrontUrl;
    /**
     * 挂靠声明URL
     */
    @Length(max = 200, message = "参数attachedStatementUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String attachedStatementUrl;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
