package com.esv.freight.app.module.waybill.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
/**
 * @description: 运单详情VO
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.waybill.vo.WaybillDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class WaybillDetailVO {

    /**
     * 主键
     */
    private Long id;

    /**
     * 货物明细
     */
    private String goodsDetail;

    /**
     * 货物单价
     */
    private BigDecimal goodsUnitPrice;


    /**
     * 发货地址ID
     */
    private Long deliveryAddressId;

    /**
     * 发货地址名称
     */
    private String deliveryAddressName;

    /**
     * 发货地址省份
     */
    private String deliveryProvinceCode;

    /**
     * 发货地址城市
     */
    private String deliveryCityCode;

    /**
     * 发货地址区、县
     */
    private String deliveryDistrictCode;

    /**
     * 发货详细地址
     */
    private String deliveryDetailAddress;

    /**
     * 发货人
     */
    private String deliverer;

    /**
     * 发货人手机号
     */
    private String delivererPhone;

    /**
     * 收货地址ID
     */
    private Long receiveAddressId;

    /**
     * 收货地址名称
     */
    private String receiveAddressName;

    /**
     * 收货地址省份
     */
    private String receiveProvinceCode;

    /**
     * 收货地址城市
     */
    private String receiveCityCode;

    /**
     * 收货地址区、县
     */
    private String receiveDistrictCode;

    /**
     * 收货详细地址
     */
    private String receiveDetailAddress;

    /**
     * 收货人
     */
    private String receiver;

    /**
     * 收货人电话
     */
    private String receiverPhone;

    /**
     * 要求发货时间
     */
    private Date requiredDeliveryTime;

    /**
     * 要求交货时间
     */
    private Date requiredReceiveTime;

    /**
     * 要求回单时间
     */
    private Date requiredReceiptTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
