package com.esv.freight.app.module.account.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.feign.DictInterface;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.form.LoginForm;
import com.esv.freight.app.module.account.form.RefreshTokenForm;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.account.vo.LoginVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 账号Controller
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.controller.DriverAccountController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/14 14:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/account")
@Slf4j
@Validated
public class DriverAccountController {

    private DictInterface dictInterface;
    private NoticeInterface noticeInterface;
    private AppLoginService appLoginService;

    @Autowired
    public DriverAccountController(DictInterface dictInterface, NoticeInterface noticeInterface, AppLoginService appLoginService) {
        this.dictInterface = dictInterface;
        this.noticeInterface = noticeInterface;
        this.appLoginService = appLoginService;
    }

    /**
     * description 短信验证码登录
     * param [LoginBySmsForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 14:00
     **/
    @PostMapping("/login/loginBySms")
    public EResponse loginBySms(@RequestBody(required=false) @Validated(ValidatorInsert.class) LoginForm loginForm) {

        if(loginForm == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }

        // 调用通知服务验证短信接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("phone", loginForm.getPhone());
        reqJson.put("type", "login");
        reqJson.put("captcha", loginForm.getSmsCode());
        log.info(reqJson.toJSONString());
        JSONObject result = noticeInterface.checkSmsCaptcha(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 200) {
            LoginVO loginByPwdVO = appLoginService.login(loginForm.getPhone());
            return EResponse.ok(loginByPwdVO);
        }

        return EResponse.error(result.getInteger("code"), result.getString("message"));
    }

    /**
     * description 帐号密码登录RequestHeader
     * param [LoginByPwdForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 14:00
     **/
    @PostMapping("/login/loginByPwd")
    public EResponse loginByPwd(@RequestBody(required=false) @Validated(ValidatorInsert.class) LoginForm loginForm) {

        if(loginForm == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }
        /*

        if(!appLoginService.isExistAccount(loginByPwdForm.getPhone())) {
            return EResponse.error(1001, "账号不存在");
        }

        // TODO，Feign调用货主账号密码,目前暂时先假定密码为1234qwer(MD5加密)
        if(!"62c8ad0a15d9d1ca38d5dee762a16e01".equals(loginByPwdForm.getPwd())) {
            return EResponse.error(1003, "密码错误");
        }*/

        LoginVO loginByPwdVO = appLoginService.login(loginForm.getPhone());
        return EResponse.ok(loginByPwdVO);
    }

    /**
     * description 帐号登出
     * param
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 14:00
     **/
    @PostMapping("/logout")
    public EResponse logout(@RequestHeader("Union-Authorization") String accessToken) {
        appLoginService.logout(accessToken);
        return EResponse.ok();
    }

    /**
     * description 刷新Token
     * param [refreshToken] 刷新Token
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/13 09:00
     **/
    @PostMapping("/token/refresh")
    public EResponse refresh(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorInsert.class) RefreshTokenForm refreshTokenForm) {

        LoginVO loginByPwdVO = appLoginService.refreshToken(accessToken, refreshTokenForm);
        return EResponse.ok(loginByPwdVO);
    }

    /**
     * description 获取帐号详情
     * param []
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/14 15:00
     **/
    @PostMapping("/detail")
    public EResponse detail(@RequestHeader("Union-Authorization") String accessToken) {

     //   AccountDetailVO accountDetailVO = appLoginService.getAccountDetailInfo(accessToken);
        return EResponse.ok();
    }
}
