package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.app.feign.GoodsOwnerInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/20 18:00
 * @version:1.0
 */
@FeignClient(value = "freight-customer-service")
public interface GoodsOwnerInterface {

    @PostMapping(value = "/customer/goodsowner/account/password/check")
    JSONObject checkAccountPwd(JSONObject bodyJson);

    @PostMapping(value = "/customer/goodsowner/account/register")
    JSONObject accountRegister(JSONObject bodyJson);

    @PostMapping(value = "/customer/goodsowner/account/detail")
    JSONObject getAccountDetail(JSONObject bodyJson);

    @PostMapping(value = "/customer/goodsowner/account/edit")
    JSONObject updateAccountInfo(JSONObject bodyJson);
}
