package com.esv.freight.app.module.order.form;

import com.esv.freight.app.common.validator.groups.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

/**
 * @description: 订单列表验证类
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.order.form.OrderListForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class OrderQueryForm {

    /**
     * 订单ID
     */
    @NotNull(message = "参数订单ID不能为空", groups = {ValidatorDetail.class})
    private Long id;

    /**
     * 货主id
     */
    @Positive(message = "参数货主ID不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long goodsOwnerId;

    /**
     * 订单类型：1-待审核、2-已取消、3-新增、4-执行中、5-已完结
     */
    @Positive(message = "参数订单状态不合法", groups = {ValidatorList.class})
    @Range(min = 1, max = 5, message = "无效的订单状态", groups = {ValidatorList.class})
    private Integer orderState;

    /**
     * 当前页数
     */
    @Range(min = 1, max = 1000, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页显示记录数
     */
    @Range(min = 1, max = 1000, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
