package com.esv.freight.app.config;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

/**
 * @description: 注册Feign请求拦截器
 * @project: Spring-Cloud-Single-Template
 * @name: com.esv.freight.config.FeignInterceptorConfig
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/09 9:58
 * @version:1.0
 */
public class FeignInterceptorConfig {

    @Value("${spring.application.name}")
    private String applicationName;

    @Bean
    public RequestInterceptor requestInterceptor(){
        return new FeignRequestInterceptor();
    }

    class FeignRequestInterceptor implements RequestInterceptor {
        @Override
        public void apply(RequestTemplate requestTemplate) {
            requestTemplate.header("trace_id", MDC.get("traceId"));
            requestTemplate.header("application_name", applicationName);
        }
    }
}
