package com.esv.frc.client;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Slf4j
public class HttpsWithCA {

    private static SSLContext sslContext = null;

    public static void main(String[] args) throws Exception {
        /*String url = "https://testswm.gwm.com.cn/sma/api/logout";
        String body = sendHttpsPostWithCA(url, new JSONObject(), "utf-8");
        System.out.println("响应结果：" + body);*/
    }

    /**
     * 设置信任自定义证书
     *
     * @param caPath 证书路径
     * @return
     */
    public static SSLContext custom(String caPath){
        SSLContext context = null;
        FileInputStream instream = null;
        try {
            CertificateFactory cAf = CertificateFactory.getInstance("X.509");
            instream = new FileInputStream(caPath);
            X509Certificate ca = (X509Certificate) cAf.generateCertificate(instream);
            KeyStore caKs = KeyStore.getInstance("JKS");
            caKs.load(null, null);
            caKs.setCertificateEntry("ca-certificate", ca);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(caKs);

            // finally, create SSL socket factory
            context = SSLContext.getInstance("SSL");
            context.init(null, tmf.getTrustManagers(), new SecureRandom());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (null != instream) {
                    instream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return context;
    }

    /**
     * 模拟请求
     *
     * @param url		资源地址
     * @param paramJson	参数
     * @param encoding	编码
     * @return
     * @throws IOException
     * @throws KeyManagementException
     * @throws NoSuchAlgorithmException
     * @throws ClientProtocolException
     */

    /**
     * 使用自定义证书进行https请求
     * @param url
     * @param paramJson
     * @param encoding
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     */
    public static String sendHttpsPostWithCA(String fotapath,String url, JSONObject paramJson, String encoding) throws ClientProtocolException, IOException {
        String body = "";

        //SSLContext sslcontext = custom("D:\\data\\gwm.com.cn.crt");
        //SSLContext sslcontext = custom("/data/gwm.com.cn.crt");
        SSLContext sslcontext = custom(fotapath);

        // 设置协议http和https对应的处理socket链接工厂的对象
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.INSTANCE)
                .register("https", new SSLConnectionSocketFactory(sslcontext))
                .build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager(connManager);

        //创建自定义的httpclient对象
        CloseableHttpClient client = HttpClients.custom().setConnectionManager(connManager).build();
//		CloseableHttpClient client = HttpClients.createDefault();

        //创建post方式请求对象
        HttpPost httpPost = new HttpPost(url);

        // 设置header信息
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");

        // 设置请求体
        StringEntity requestEntity = new StringEntity(paramJson.toString(), Charset.forName("UTF-8"));
        requestEntity.setContentEncoding("UTF-8");
        httpPost.setEntity(requestEntity);

        //执行请求操作，并拿到结果（同步阻塞）
        CloseableHttpResponse response = client.execute(httpPost);
        //获取结果实体
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            //按指定编码转换结果实体为String类型
            body = EntityUtils.toString(entity, encoding);
        }
        EntityUtils.consume(entity);
        //释放链接
        response.close();
        return body;
    }

    public static String sendHttpsUploadFile(String fotapath,String url, MultipartFile file, String sessionId,String charset) {
        String body = "";

        if(sslContext == null){
            sslContext = custom(fotapath);
        }
        // 设置协议http和https对应的处理socket链接工厂的对象
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.INSTANCE)
                .register("https", new SSLConnectionSocketFactory(sslContext))
                .build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager(connManager);

        //创建自定义的httpclient对象
        CloseableHttpClient client = HttpClients.custom().setConnectionManager(connManager).build();

        //创建post方式请求对象
        HttpPost httpPost = new HttpPost(url);
        String fileName = file.getOriginalFilename();
        //HttpPost httpPost = new HttpPost(uploadUrl);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        try {
            builder.addBinaryBody("file", file.getInputStream(), ContentType.MULTIPART_FORM_DATA, fileName);// 文件流
        builder.addTextBody("filename", fileName);// 类似浏览器表单提交，对应input的name和value
        HttpEntity entity = builder.build();
        httpPost.setEntity(entity);
        httpPost.setHeader("Accept", "application/json");

        if(sessionId!=""){
            httpPost.setHeader("sessionId", sessionId);
        }

        //执行请求操作，并拿到结果（同步阻塞）
        CloseableHttpResponse response = client.execute(httpPost);
        //获取结果实体
        HttpEntity entity1 = response.getEntity();
        if (entity1 != null) {
            //按指定编码转换结果实体为String类型
            body = EntityUtils.toString(entity1, charset);
        }
        EntityUtils.consume(entity1);
        //释放链接
        response.close();
        }catch (Exception e){
           log.error("请求上传车辆信息文件出错，异常 = " + e);
        }
        return body;
    }

    public static String sendHttpsGetSessionId(String fotacapath,String url, Map<String,String> map, String sessionId, String charset) throws ClientProtocolException, IOException {
        String body = "";
        if(sslContext == null){
            sslContext = custom(fotacapath);
        }
        // 设置协议http和https对应的处理socket链接工厂的对象
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.INSTANCE)
                .register("https", new SSLConnectionSocketFactory(sslContext))
                .build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager(connManager);

        //创建自定义的httpclient对象
        CloseableHttpClient client = HttpClients.custom().setConnectionManager(connManager).build();

        //创建post方式请求对象
        HttpPost httpPost = new HttpPost(url);

        httpPost.setHeader("Accept", "application/json");

        Iterator iterator = map.entrySet().iterator();
        List<NameValuePair> list = new ArrayList<NameValuePair>();
        while(iterator.hasNext()){
            Map.Entry<String,String> elem = (Map.Entry<String, String>) iterator.next();
            list.add(new BasicNameValuePair(elem.getKey(),elem.getValue()));
        }
        if(list.size() > 0){
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list,charset);
            httpPost.setEntity(entity);
        }

        //执行请求操作，并拿到结果（同步阻塞）
        CloseableHttpResponse response = client.execute(httpPost);
        //获取结果实体
        HttpEntity entity1 = response.getEntity();
        if (entity1 != null) {
            //按指定编码转换结果实体为String类型
            body = EntityUtils.toString(entity1, charset);
        }
        EntityUtils.consume(entity1);
        //释放链接
        response.close();
        return body;
    }

}
